/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandListener;
import com.github.johnnyjayjay.discord.commandapi.CommandSetException;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.bot.sharding.ShardManager;
import net.dv8tion.jda.core.JDA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSettings {
    public static final Logger logger = LoggerFactory.getLogger((String)"CommandAPI");
    public static final String VALID_PREFIX = "[^\\\\+*^|$?]+";
    public static final String VALID_LABEL = "[^\\s]+";
    private final String INVALID_PREFIX_MESSAGE = "Prefix cannot be empty or contain the characters +*^|$\\?";
    private final String INVALID_LABEL_MESSAGE = "Label cannot be empty, consist of multiple words or contain new lines!";
    private String defaultPrefix;
    private long cooldown = 0L;
    private Color helpColor;
    private Set<Long> blacklistedChannels;
    private Set<String> helpLabels;
    private Map<Long, String> prefixMap;
    private Map<String, ICommand> commands = new HashMap<String, ICommand>();
    private Object jda;
    private CommandListener listener = new CommandListener(this);
    private boolean activated = false;
    private boolean useShardManager;
    private boolean labelIgnoreCase;
    private boolean botExecution = false;

    public CommandSettings(@Nonnull String defaultPrefix, @Nonnull ShardManager shardManager, boolean labelIgnoreCase) {
        this(defaultPrefix, labelIgnoreCase);
        this.jda = shardManager;
        this.useShardManager = true;
    }

    public CommandSettings(@Nonnull String defaultPrefix, @Nonnull JDA jda, boolean labelIgnoreCase) {
        this(defaultPrefix, labelIgnoreCase);
        this.jda = jda;
        this.useShardManager = false;
    }

    private CommandSettings(@Nonnull String defaultPrefix, boolean labelIgnoreCase) {
        this.helpColor = Color.LIGHT_GRAY;
        this.setDefaultPrefix(defaultPrefix);
        this.labelIgnoreCase = labelIgnoreCase;
        this.blacklistedChannels = new HashSet<Long>();
        this.helpLabels = new HashSet<String>();
        this.prefixMap = new HashMap<Long, String>();
    }

    public CommandSettings addHelpLabel(String label) {
        if (!label.matches(VALID_LABEL)) {
            throw new CommandSetException("Label cannot be empty, consist of multiple words or contain new lines!");
        }
        this.helpLabels.add(this.labelIgnoreCase ? label.toLowerCase() : label);
        return this;
    }

    public CommandSettings addHelpLabels(String ... labels) {
        for (String label : labels) {
            this.addHelpLabel(label);
        }
        return this;
    }

    public CommandSettings addHelpLabels(@Nonnull Collection<String> labels) {
        this.helpLabels.addAll(this.labelIgnoreCase ? (Collection)labels.stream().map(String::toLowerCase).collect(Collectors.toList()) : labels);
        return this;
    }

    public boolean removeHelpLabel(String label) {
        return this.helpLabels.remove(this.labelIgnoreCase ? label.toLowerCase() : label);
    }

    public boolean removeHelpLabels(String ... labels) {
        boolean success = true;
        for (String label : labels) {
            if (this.removeHelpLabel(label)) continue;
            success = false;
        }
        return success;
    }

    public boolean removeHelpLabels(@Nonnull Collection<String> labels) {
        return this.helpLabels.removeAll(this.labelIgnoreCase ? (Collection)labels.stream().map(String::toLowerCase).collect(Collectors.toList()) : labels);
    }

    public CommandSettings clearHelpLabels() {
        this.helpLabels.clear();
        return this;
    }

    public CommandSettings addChannelToBlacklist(long channelId) {
        this.blacklistedChannels.add(channelId);
        return this;
    }

    public CommandSettings addChannelsToBlacklist(long ... channelIds) {
        for (long id : channelIds) {
            this.addChannelToBlacklist(id);
        }
        return this;
    }

    public CommandSettings addChannelsToBlacklist(Collection<Long> channelIds) {
        this.blacklistedChannels.addAll(channelIds);
        return this;
    }

    public boolean removeChannelFromBlacklist(long channelId) {
        return this.blacklistedChannels.remove(channelId);
    }

    public boolean removeChannelsFromBlacklist(long ... channelIds) {
        boolean success = true;
        for (long id : channelIds) {
            if (this.removeChannelFromBlacklist(id)) continue;
            success = false;
        }
        return success;
    }

    public boolean removeChannelsFromBlackList(Collection<Long> channelIds) {
        return this.blacklistedChannels.removeAll(channelIds);
    }

    public CommandSettings clearBlacklist() {
        this.blacklistedChannels.clear();
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, String label) {
        if (!label.matches(VALID_LABEL)) {
            throw new CommandSetException("Label cannot be empty, consist of multiple words or contain new lines!");
        }
        this.commands.put(this.labelIgnoreCase ? label.toLowerCase() : label, executor);
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, String ... labels) {
        for (String label : labels) {
            this.put(executor, label);
        }
        return this;
    }

    public CommandSettings put(@Nonnull ICommand executor, @Nonnull Collection<String> labels) {
        this.put(executor, labels.toArray(new String[labels.size()]));
        return this;
    }

    public boolean remove(String label) {
        return this.commands.remove(this.labelIgnoreCase ? label.toLowerCase() : label) != null;
    }

    public boolean remove(String ... labels) {
        boolean success = true;
        for (String label : labels) {
            if (this.remove(label)) continue;
            success = false;
        }
        return success;
    }

    public boolean remove(@Nonnull Collection<String> labels) {
        return this.remove(labels.toArray(new String[labels.size()]));
    }

    public CommandSettings clearCommands() {
        this.commands.clear();
        return this;
    }

    public CommandSettings clear() {
        this.clearBlacklist().clearCommands().clearHelpLabels();
        this.botExecution = false;
        this.cooldown = 0L;
        if (this.activated) {
            this.deactivate();
        }
        return this;
    }

    public void setDefaultPrefix(@Nonnull String prefix) {
        if (!prefix.matches(VALID_PREFIX)) {
            throw new CommandSetException("Prefix cannot be empty or contain the characters +*^|$\\?");
        }
        this.defaultPrefix = prefix;
    }

    public void setCustomPrefix(long guildId, @Nullable String prefix) {
        if (prefix != null && !prefix.matches(VALID_PREFIX)) {
            throw new CommandSetException("Prefix cannot be empty or contain the characters +*^|$\\?");
        }
        this.prefixMap.put(guildId, prefix);
    }

    public CommandSettings setCooldown(long msCooldown) {
        this.cooldown = msCooldown;
        return this;
    }

    public CommandSettings setBotExecution(boolean botExecution) {
        this.botExecution = botExecution;
        return this;
    }

    public CommandSettings setHelpCommandColor(Color color) {
        this.helpColor = color;
        return this;
    }

    public void activate() {
        if (!this.activated) {
            if (this.useShardManager) {
                ((ShardManager)this.jda).addEventListener(new Object[]{this.listener});
            } else {
                ((JDA)this.jda).addEventListener(new Object[]{this.listener});
            }
        } else {
            throw new CommandSetException("CommandSettings already activated!");
        }
        this.activated = true;
    }

    public void deactivate() {
        if (this.activated) {
            if (this.useShardManager) {
                ((ShardManager)this.jda).removeEventListener(new Object[]{this.listener});
            } else {
                ((JDA)this.jda).removeEventListener(new Object[]{this.listener});
            }
        } else {
            throw new CommandSetException("CommandSettings weren't activated yet and can therefore not be deactivated!");
        }
        this.activated = false;
    }

    public String getPrefix(long guildId) {
        return this.prefixMap.get(guildId) != null ? this.prefixMap.get(guildId) : this.defaultPrefix;
    }

    public String getPrefix() {
        return this.defaultPrefix;
    }

    public Set<Long> getBlacklistedChannels() {
        return Collections.unmodifiableSet(this.blacklistedChannels);
    }

    public Set<String> getLabelSet() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    public Set<String> getHelpLabelSet() {
        return Collections.unmodifiableSet(this.helpLabels);
    }

    public boolean isActivated() {
        return this.activated;
    }

    protected long getCooldown() {
        return this.cooldown;
    }

    protected boolean labelIgnoreCase() {
        return this.labelIgnoreCase;
    }

    protected boolean botsMayExecute() {
        return this.botExecution;
    }

    protected Set<String> getHelpLabels() {
        return this.helpLabels;
    }

    protected Map<String, ICommand> getCommands() {
        return this.commands;
    }

    protected Color getHelpColor() {
        return this.helpColor;
    }
}

