/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.CommandEvent;
import com.github.johnnyjayjay.discord.commandapi.CommandSettings;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import com.github.johnnyjayjay.discord.commandapi.SubCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.TextChannel;

public abstract class AbstractCommand
implements ICommand {
    protected final String MEMBER_MENTION = "<@!?\\d+>";
    protected final String ROLE_MENTION = "<&\\d+>";
    protected final String CHANNEL_MENTION = "<#\\d+>";
    private final Map<SubCommand, Method> subCommands;

    protected AbstractCommand() {
        Object[] parameterTypes = new Class[]{CommandEvent.class, Member.class, TextChannel.class, String[].class};
        this.subCommands = new HashMap<SubCommand, Method>();
        for (Method method : this.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(SubCommand.class)) continue;
            if (method.getReturnType().equals(Void.TYPE) && Modifier.isPublic(method.getModifiers()) && Arrays.equals(method.getParameterTypes(), parameterTypes)) {
                this.subCommands.put(method.getAnnotation(SubCommand.class), method);
                continue;
            }
            CommandSettings.LOGGER.warn("You are using an invalid method signature for the SubCommand-annotation on method" + this.getClass().getName() + "#" + method.getName() + ".\nExpected: void (com.github.johnnyjayjay.commandapi.CommandEvent, net.dv8tion.jda.core.entities.Member, net.dv8tion.jda.core.entities.TextChannel, java.lang.String[])\nFound: " + method.getReturnType().getName() + " (" + Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(Collectors.joining(", ")) + ")\nThis method will therefore be ignored.");
        }
    }

    @Override
    public final void onCommand(CommandEvent event, Member member, TextChannel channel, String[] args) {
        CommandSettings settings = event.getCommandSettings();
        Optional<SubCommand> matchesArgs = this.subCommands.keySet().stream().filter(sub -> !sub.isDefault()).filter(sub -> sub.args().length == args.length || sub.moreArgs() && args.length > sub.args().length).filter(sub -> {
            for (int i = 0; i < sub.args().length; ++i) {
                String regex;
                String string = regex = settings.isLabelIgnoreCase() ? "(?i)" + sub.args()[i] : sub.args()[i];
                if (args[i].matches(regex)) continue;
                return false;
            }
            return true;
        }).filter(sub -> event.checkBotPermissions(sub.botPerms())).findFirst();
        if (matchesArgs.isPresent()) {
            this.invokeMethod(this.subCommands.get(matchesArgs.get()), event, member, channel, args);
        } else {
            this.subCommands.keySet().stream().filter(sub -> event.checkBotPermissions(sub.botPerms())).filter(SubCommand::isDefault).findFirst().map(this.subCommands::get).ifPresent(method -> this.invokeMethod((Method)method, event, member, channel, args));
        }
    }

    private void invokeMethod(Method method, CommandEvent event, Member member, TextChannel channel, String[] args) {
        try {
            method.invoke((Object)this, new Object[]{event, member, channel, args});
        }
        catch (IllegalAccessException e) {
            CommandSettings.LOGGER.error("An Exception occurred while trying to invoke sub command method; Please report this in a github issue. https://github.com/JohnnyJayJay/discord-api-command/issues", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            CommandSettings.LOGGER.warn("One of the commands had an uncaught exception:", e.getCause());
        }
    }
}

