/*
 * Decompiled with CFR 0.152.
 */
package com.github.johnnyjayjay.discord.commandapi;

import com.github.johnnyjayjay.discord.commandapi.AbstractHelpCommand;
import com.github.johnnyjayjay.discord.commandapi.CommandEvent;
import com.github.johnnyjayjay.discord.commandapi.CommandSettings;
import com.github.johnnyjayjay.discord.commandapi.ICommand;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.dv8tion.jda.core.EmbedBuilder;
import net.dv8tion.jda.core.MessageBuilder;
import net.dv8tion.jda.core.Permission;
import net.dv8tion.jda.core.entities.Member;
import net.dv8tion.jda.core.entities.Message;

public final class DefaultHelpCommand
extends AbstractHelpCommand {
    private final Message info = new MessageBuilder().setContent("Command info:\nShows all available commands or provides help for a specific command.").build();

    @Override
    public void provideGeneralHelp(CommandEvent event, String prefix, Map<String, ICommand> commands) {
        Member selfMember = event.getGuild().getSelfMember();
        if (event.checkBotPermissions(Permission.MESSAGE_WRITE, Permission.MESSAGE_EMBED_LINKS)) {
            return;
        }
        CommandSettings settings = event.getCommandSettings();
        EmbedBuilder embed = new EmbedBuilder().setColor(settings.getHelpColor() != null ? settings.getHelpColor() : selfMember.getColor());
        String helpLabels = "[" + String.join((CharSequence)"|", settings.getLabels(this)) + "]";
        embed.appendDescription((CharSequence)"To learn more about a specific command, just call `").appendDescription((CharSequence)prefix).appendDescription((CharSequence)helpLabels).appendDescription((CharSequence)" <label>`.\nThe following commands are currently available:\n");
        String commandsList = commands.keySet().stream().map(label -> prefix + label).collect(Collectors.joining(", "));
        if (commandsList.length() < 1010) {
            embed.addField("Commands", "```\n" + commandsList + "```", false);
        } else {
            embed.addField("Warning", "Too many commands to show.", false);
        }
        event.getChannel().sendMessage(embed.build()).queue();
    }

    @Override
    public void provideSpecificHelp(CommandEvent event, String prefix, ICommand command, Set<String> labels) {
        if (!event.checkBotPermissions(Permission.MESSAGE_WRITE, Permission.MESSAGE_EMBED_LINKS)) {
            return;
        }
        event.getChannel().sendMessage(command.info(event.getMember(), prefix, labels)).queue();
    }

    @Override
    public Message info(Member member, String prefix, Set<String> labels) {
        return this.info;
    }
}

