/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.impl;

import com.github.jsonldjava.core.JSONLD;
import com.github.jsonldjava.core.JSONLDProcessingError;
import com.github.jsonldjava.core.JSONLDTripleCallback;
import com.github.jsonldjava.impl.ClerezzaTripleCallback;
import com.github.jsonldjava.utils.JSONUtils;
import java.io.IOException;
import java.io.InputStream;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.Triple;
import org.junit.Assert;
import org.junit.Test;

public class ClerezzaTripleCallbackTest {
    @Test
    public void triplesTest() throws IOException, JSONLDProcessingError {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("testfiles/product.jsonld");
        Object input = JSONUtils.fromInputStream((InputStream)in);
        ClerezzaTripleCallback callback = new ClerezzaTripleCallback();
        MGraph graph = (MGraph)JSONLD.toRDF((Object)input, (JSONLDTripleCallback)callback);
        for (Triple t : graph) {
            System.out.println(t);
        }
        Assert.assertEquals((String)"Graph size", (long)13L, (long)graph.size());
    }

    @Test
    public void curiesInContextTest() throws IOException, JSONLDProcessingError {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("testfiles/curies-in-context.jsonld");
        Object input = JSONUtils.fromInputStream((InputStream)in);
        ClerezzaTripleCallback callback = new ClerezzaTripleCallback();
        MGraph graph = (MGraph)JSONLD.toRDF((Object)input, (JSONLDTripleCallback)callback);
        for (Triple t : graph) {
            System.out.println(t);
            Assert.assertTrue((String)"Predicate got fully expanded", (boolean)t.getPredicate().getUnicodeString().startsWith("http"));
        }
        Assert.assertEquals((String)"Graph size", (long)3L, (long)graph.size());
    }
}

