/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import com.github.libxjava.io.ByteArrayInputBuffer;
import com.github.libxjava.io.ByteArrayOutputBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class BaseX {
    private final Object _workLock = new Object();
    private final ByteArrayOutputBuffer _workOutput = new ByteArrayOutputBuffer();
    private final ByteArrayInputBuffer _workInput = new ByteArrayInputBuffer();

    protected BaseX() {
    }

    public final byte[] encode(byte[] b) {
        return this.encode(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] encode(byte[] b, int off, int len) {
        Object object = this._workLock;
        synchronized (object) {
            this._workOutput.reset();
            this._workInput.setInput(b, off, len);
            try {
                this.internalEncode(this._workInput, this._workOutput);
            }
            catch (IOException e) {
                throw new Error(e.getMessage());
            }
            return this._workOutput.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encode(byte[] b, int off, int len, OutputStream out) throws IOException {
        Object object = this._workLock;
        synchronized (object) {
            this._workInput.setInput(b, off, len);
            this.internalDecode(this._workInput, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void encode(InputStream in, OutputStream out) throws IOException {
        Object object = this._workLock;
        synchronized (object) {
            this.internalEncode(in, out);
        }
    }

    public final byte[] decode(byte[] b) {
        return this.decode(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] decode(byte[] b, int off, int len) {
        Object object = this._workLock;
        synchronized (object) {
            this._workOutput.reset();
            this._workInput.setInput(b, off, len);
            try {
                this.internalDecode(this._workInput, this._workOutput);
            }
            catch (IOException e) {
                throw new Error(e.getMessage());
            }
            return this._workOutput.toByteArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decode(InputStream in, OutputStream out) throws IOException {
        Object object = this._workLock;
        synchronized (object) {
            this.internalDecode(in, out);
        }
    }

    protected abstract void internalDecode(InputStream var1, OutputStream var2) throws IOException;

    protected abstract void internalEncode(InputStream var1, OutputStream var2) throws IOException;
}

