/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.io;

import java.io.OutputStream;

public final class ByteArrayOutputBuffer
extends OutputStream {
    private byte[] _buffer;
    private int _count;

    public ByteArrayOutputBuffer() {
        this(16);
    }

    public ByteArrayOutputBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this._buffer = new byte[size];
        this._count = 0;
    }

    public byte[] getByteArrayReference() {
        return this._buffer;
    }

    public byte[] toByteArray() {
        byte[] result = new byte[this._count];
        System.arraycopy(this._buffer, 0, result, 0, this._count);
        return result;
    }

    public void reset() {
        this._count = 0;
    }

    public void resetNew() {
        this.resetNew(16);
    }

    public void resetNew(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this._buffer = new byte[size];
        this._count = 0;
    }

    public void setOutput(byte[] buffer, int off) {
        this._buffer = buffer;
        this._count = off;
    }

    public int size() {
        return this._count;
    }

    public void close() {
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int newCount = this._count + len;
        if (newCount > this._buffer.length) {
            int newLength = this._buffer.length << 1;
            byte[] newBuf = new byte[newLength < newCount ? newCount : newLength];
            System.arraycopy(this._buffer, 0, newBuf, 0, this._count);
            this._buffer = newBuf;
        }
        System.arraycopy(b, off, this._buffer, this._count, len);
        this._count = newCount;
    }

    public void write(int b) {
        int newCount = this._count + 1;
        if (newCount > this._buffer.length) {
            byte[] newBuf = new byte[this._buffer.length << 1];
            System.arraycopy(this._buffer, 0, newBuf, 0, this._count);
            this._buffer = newBuf;
        }
        this._buffer[this._count] = (byte)b;
        this._count = newCount;
    }
}

