/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.util;

import com.github.libxjava.util.HashRingSetEntry;

public class HashRingSet {
    private static final int LOAD_FACTOR = 75;
    private final HashRingSetEntry[] _table;
    private final Object[] _content;
    private int _count;
    private int _pos;

    public HashRingSet(int capacity) {
        this._content = new Object[capacity];
        this._table = new HashRingSetEntry[100 * capacity / 75];
        this._count = 0;
        this._pos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object obj) {
        Object[] objectArray = this._content;
        synchronized (this._content) {
            int hash = obj.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this._table.length;
            HashRingSetEntry e = this._table[index];
            while (e != null) {
                if (e.hash == hash && this._content[e.index].equals(obj)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                e = e.next;
            }
            e = new HashRingSetEntry();
            e.hash = hash;
            e.index = this._pos;
            e.next = this._table[index];
            this._table[index] = e;
            if (this._count >= this._content.length) {
                if (!this.freePosition()) {
                    throw new Error("implementation bug");
                }
            } else {
                ++this._count;
            }
            this._content[this._pos] = obj;
            this._pos = (this._pos + 1) % this._content.length;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object obj) {
        Object[] objectArray = this._content;
        synchronized (this._content) {
            int hash = obj.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this._table.length;
            HashRingSetEntry e = this._table[index];
            while (e != null) {
                if (e.hash == hash && this._content[e.index].equals(obj)) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                e = e.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object[] objectArray = this._content;
        synchronized (this._content) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('[');
            int preLast = this._count - 1;
            int c = 0;
            int i = this._content.length + this._pos - this._count;
            while (c <= preLast) {
                buffer.append(String.valueOf(this._content[i % this._content.length]));
                if (c < preLast) {
                    buffer.append(", ");
                }
                ++c;
                ++i;
            }
            buffer.append(']');
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return buffer.toString();
        }
    }

    private boolean freePosition() {
        int hash = this._content[this._pos].hashCode();
        int tableIndex = (hash & Integer.MAX_VALUE) % this._table.length;
        HashRingSetEntry e = this._table[tableIndex];
        HashRingSetEntry prev = null;
        while (e != null) {
            if (e.hash == hash && e.index == this._pos) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    this._table[tableIndex] = e.next;
                }
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }
}

