/*
 * Decompiled with CFR 0.152.
 */
package com.github.libxjava.util;

import com.github.libxjava.io.IDeserialiser;
import com.github.libxjava.io.ISerialisable;
import com.github.libxjava.io.ISerialiser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class SerialisableHashtable
extends Hashtable
implements ISerialisable {
    private static final long serialVersionUID = 1L;

    public SerialisableHashtable() {
    }

    public SerialisableHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public synchronized void deserialise(IDeserialiser in) throws IOException, ClassNotFoundException {
        this.clear();
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            super.put(in.readObject(), in.readObject());
        }
    }

    public synchronized void serialise(ISerialiser out) throws IOException {
        int count = this.size();
        out.writeInt(count);
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            out.writeObject(key);
            out.writeObject(this.get(key));
        }
    }
}

