/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.codec;

import com.mpush.api.Logger;
import com.mpush.api.PacketWriter;
import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Packet;
import com.mpush.client.ClientConfig;
import com.mpush.codec.PacketEncoder;
import com.mpush.util.ByteBuf;
import com.mpush.util.thread.EventLock;
import com.mpush.util.thread.ExecutorManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Executor;

public final class AsyncPacketWriter
implements PacketWriter {
    private final Executor executor = ExecutorManager.INSTANCE.getWriteThread();
    private final Logger logger;
    private final Connection connection;
    private final EventLock connLock;
    private final ByteBuf buffer;

    public AsyncPacketWriter(Connection connection, EventLock connLock) {
        this.connection = connection;
        this.connLock = connLock;
        this.buffer = ByteBuf.allocateDirect(1024);
        this.logger = ClientConfig.I.getLogger();
    }

    @Override
    public void write(Packet packet) {
        this.executor.execute(new WriteTask(packet));
    }

    private class WriteTask
    implements Runnable {
        private final long sendTime = System.currentTimeMillis();
        private final Packet packet;

        private WriteTask(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            AsyncPacketWriter.this.buffer.clear();
            PacketEncoder.encode(this.packet, AsyncPacketWriter.this.buffer);
            AsyncPacketWriter.this.buffer.flip();
            ByteBuffer out = AsyncPacketWriter.this.buffer.nioBuffer();
            while (out.hasRemaining()) {
                if (AsyncPacketWriter.this.connection.isConnected()) {
                    try {
                        AsyncPacketWriter.this.connection.getChannel().write(out);
                        AsyncPacketWriter.this.connection.setLastWriteTime();
                    }
                    catch (IOException e) {
                        AsyncPacketWriter.this.logger.e(e, "write packet ex, do reconnect, packet=%s", this.packet);
                        if (this.isTimeout()) {
                            AsyncPacketWriter.this.logger.w("ignored timeout packet=%s, sendTime=%d", this.packet, this.sendTime);
                            return;
                        }
                        AsyncPacketWriter.this.connection.reconnect();
                    }
                    continue;
                }
                if (this.isTimeout()) {
                    AsyncPacketWriter.this.logger.w("ignored timeout packet=%s, sendTime=%d", this.packet, this.sendTime);
                    return;
                }
                AsyncPacketWriter.this.connLock.await(10000L);
            }
            AsyncPacketWriter.this.logger.d("write packet end, packet=%s, costTime=%d", this.packet.cmd, System.currentTimeMillis() - this.sendTime);
        }

        public boolean isTimeout() {
            return System.currentTimeMillis() - this.sendTime > 10000L;
        }
    }
}

