/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.message;

import com.mpush.api.connection.Connection;
import com.mpush.api.protocol.Command;
import com.mpush.api.protocol.Packet;
import com.mpush.message.ByteBufMessage;
import com.mpush.util.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class HandshakeMessage
extends ByteBufMessage {
    public String deviceId;
    public String osName;
    public String osVersion;
    public String clientVersion;
    public byte[] iv;
    public byte[] clientKey;
    public int minHeartbeat;
    public int maxHeartbeat;
    public long timestamp;

    public HandshakeMessage(Connection connection) {
        super(new Packet(Command.HANDSHAKE, HandshakeMessage.genSessionId()), connection);
    }

    public HandshakeMessage(Packet message, Connection connection) {
        super(message, connection);
    }

    @Override
    protected void decode(ByteBuffer body) {
        this.deviceId = this.decodeString(body);
        this.osName = this.decodeString(body);
        this.osVersion = this.decodeString(body);
        this.clientVersion = this.decodeString(body);
        this.iv = this.decodeBytes(body);
        this.clientKey = this.decodeBytes(body);
        this.minHeartbeat = this.decodeInt(body);
        this.maxHeartbeat = this.decodeInt(body);
        this.timestamp = this.decodeLong(body);
    }

    @Override
    protected void encode(ByteBuf body) {
        this.encodeString(body, this.deviceId);
        this.encodeString(body, this.osName);
        this.encodeString(body, this.osVersion);
        this.encodeString(body, this.clientVersion);
        this.encodeBytes(body, this.iv);
        this.encodeBytes(body, this.clientKey);
        this.encodeInt(body, this.minHeartbeat);
        this.encodeInt(body, this.maxHeartbeat);
        this.encodeLong(body, this.timestamp);
    }

    @Override
    public String toString() {
        return "HandshakeMessage{deviceId='" + this.deviceId + '\'' + ", osName='" + this.osName + '\'' + ", osVersion='" + this.osVersion + '\'' + ", clientVersion='" + this.clientVersion + '\'' + ", iv=" + Arrays.toString(this.iv) + ", clientKey=" + Arrays.toString(this.clientKey) + ", minHeartbeat=" + this.minHeartbeat + ", maxHeartbeat=" + this.maxHeartbeat + ", timestamp=" + this.timestamp + '}';
    }
}

