/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.session;

import com.mpush.api.connection.Cipher;
import com.mpush.security.AesCipher;
import com.mpush.util.Strings;

public final class PersistentSession {
    public String sessionId;
    public long expireTime;
    public Cipher cipher;

    public boolean isExpired() {
        return this.expireTime < System.currentTimeMillis();
    }

    public static String encode(PersistentSession session) {
        return session.sessionId + "," + session.expireTime + "," + session.cipher.toString();
    }

    public static PersistentSession decode(String value) {
        String[] array = value.split(",");
        if (array.length != 4) {
            return null;
        }
        PersistentSession session = new PersistentSession();
        session.sessionId = array[0];
        session.expireTime = Strings.toLong(array[1], 0L);
        byte[] key = AesCipher.toArray(array[2]);
        byte[] iv = AesCipher.toArray(array[3]);
        if (key == null || iv == null) {
            return null;
        }
        session.cipher = new AesCipher(key, iv);
        return session;
    }

    public String toString() {
        return "PersistentSession{sessionId='" + this.sessionId + '\'' + ", expireTime=" + this.expireTime + ", cipher=" + this.cipher + '}';
    }
}

