/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.util.crypto;

import com.mpush.api.Constants;
import com.mpush.client.ClientConfig;
import com.mpush.util.crypto.Base64Utils;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public final class RSAUtils {
    private static final int RAS_KEY_SIZE = 1024;
    public static final String KEY_ALGORITHM = "RSA";
    public static final String KEY_ALGORITHM_PADDING = "RSA/ECB/PKCS1Padding";
    public static final String SIGNATURE_ALGORITHM = "MD5withRSA";
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final int MAX_ENCRYPT_BLOCK = 117;

    public static String encodeBase64(Key key) throws Exception {
        return Base64Utils.encode(key.getEncoded());
    }

    public static PrivateKey decodePrivateKey(String key) throws Exception {
        byte[] keyBytes = Base64Utils.decode(key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public static PublicKey decodePublicKey(String publicKey) throws Exception {
        byte[] keyBytes = Base64Utils.decode(publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        return keyFactory.generatePublic(x509KeySpec);
    }

    public static String sign(byte[] data, String privateKey) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(RSAUtils.decodePrivateKey(privateKey));
        signature.update(data);
        return Base64Utils.encode(signature.sign());
    }

    public static boolean verify(byte[] data, String publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(RSAUtils.decodePublicKey(publicKey));
        signature.update(data);
        return signature.verify(Base64Utils.decode(sign));
    }

    public static RSAPublicKey getPublicKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(b1, b2);
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static RSAPrivateKey getPrivateKey(String modulus, String exponent) {
        try {
            BigInteger b1 = new BigInteger(modulus);
            BigInteger b2 = new BigInteger(exponent);
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(b1, b2);
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] encryptByPublicKey(byte[] data, RSAPublicKey publicKey) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
            cipher.init(1, publicKey);
            int key_len = publicKey.getModulus().bitLength() / 8;
            return RSAUtils.doFinal(cipher, data, key_len - 11);
        }
        catch (Exception e) {
            ClientConfig.I.getLogger().e(e, "encryptByPublicKey ex", new Object[0]);
            return Constants.EMPTY_BYTES;
        }
    }

    public static byte[] decryptByPrivateKey(byte[] data, RSAPrivateKey privateKey) {
        try {
            Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
            cipher.init(2, privateKey);
            int key_len = privateKey.getModulus().bitLength() / 8;
            return RSAUtils.doFinal(cipher, data, key_len);
        }
        catch (Exception e) {
            ClientConfig.I.getLogger().e(e, "decryptByPrivateKey ex", new Object[0]);
            return Constants.EMPTY_BYTES;
        }
    }

    private static byte[] doFinal(Cipher cipher, byte[] data, int key_len) throws BadPaddingException, IllegalBlockSizeException {
        int inputLen;
        int offSet = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream(RSAUtils.getTmpArrayLength(inputLen));
        for (inputLen = data.length; inputLen > 0; inputLen -= key_len) {
            byte[] tmp = cipher.doFinal(data, offSet, Math.min(key_len, inputLen));
            out.write(tmp, 0, tmp.length);
            offSet += key_len;
        }
        return out.toByteArray();
    }

    private static int getTmpArrayLength(int L) {
        int S;
        for (S = 128; S < L; S <<= 1) {
        }
        return S;
    }

    public static byte[] decryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        PrivateKey key = RSAUtils.decodePrivateKey(privateKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(2, key);
        return RSAUtils.doFinal(cipher, data, 128);
    }

    public static byte[] decryptByPublicKey(byte[] data, String publicKey) throws Exception {
        PublicKey key = RSAUtils.decodePublicKey(publicKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(2, key);
        return RSAUtils.doFinal(cipher, data, 128);
    }

    public static byte[] encryptByPublicKey(byte[] data, String publicKey) throws Exception {
        PublicKey key = RSAUtils.decodePublicKey(publicKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(1, key);
        return RSAUtils.doFinal(cipher, data, 117);
    }

    public static byte[] encryptByPrivateKey(byte[] data, String privateKey) throws Exception {
        PrivateKey key = RSAUtils.decodePrivateKey(privateKey);
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM_PADDING);
        cipher.init(1, key);
        return RSAUtils.doFinal(cipher, data, 117);
    }
}

