/*
 * Decompiled with CFR 0.152.
 */
package com.mpush.util.thread;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class EventLock {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void signal() {
        this.cond.signal();
    }

    public void signalAll() {
        this.cond.signalAll();
    }

    public void broadcast() {
        this.lock.lock();
        this.cond.signalAll();
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout) {
        this.lock.lock();
        try {
            this.cond.awaitNanos(TimeUnit.MILLISECONDS.toNanos(timeout));
        }
        catch (InterruptedException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    public boolean await() {
        this.lock.lock();
        try {
            this.cond.await();
        }
        catch (InterruptedException e) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    public Condition getCond() {
        return this.cond;
    }
}

