/*
 * Decompiled with CFR 0.152.
 */
package internal.nbbrd.design;

import internal.nbbrd.design.proc.Processing;
import internal.nbbrd.design.proc.Rule;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import nbbrd.design.MightBePromoted;

@SupportedAnnotationTypes(value={"nbbrd.design.MightBePromoted"})
public final class MightBePromotedProcessor
extends AbstractProcessor {
    private static final Rule<Element> INTERNAL_OR_NOT_PUBLIC = Rule.of(MightBePromotedProcessor::isInternalOrNotPublic, "'%s' must be in internal package or not public");
    private static final Rule<Element> IS_MIGHT_BE_PROMOTED = Rule.on(Element.class).and(INTERNAL_OR_NOT_PUBLIC);

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return Processing.of(IS_MIGHT_BE_PROMOTED).process(annotations, roundEnv, this.processingEnv);
    }

    private static boolean isInternalOrNotPublic(ProcessingEnvironment env, Element element) {
        return MightBePromotedProcessor.isTypeInInternalPackage(env, element) || MightBePromotedProcessor.isNotPublic(env, element);
    }

    private static boolean isTypeInInternalPackage(ProcessingEnvironment env, Element element) {
        if (element instanceof TypeElement) {
            TypeElement type = (TypeElement)element;
            PackageElement pkg = env.getElementUtils().getPackageOf(type);
            String fullname = pkg.getQualifiedName().toString();
            String packagePattern = type.getAnnotation(MightBePromoted.class).packagePattern();
            return fullname.matches(packagePattern);
        }
        return false;
    }

    public static boolean isNotPublic(ProcessingEnvironment env, Element element) {
        return !element.getModifiers().contains((Object)Modifier.PUBLIC);
    }
}

