/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.sql.jdbc;

import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum SqlIdentifierStorageRule {
    UPPER{

        @Override
        public boolean isValid(String identifier) {
            return identifier.toUpperCase(Locale.ROOT).equals(identifier);
        }
    }
    ,
    LOWER{

        @Override
        public boolean isValid(String identifier) {
            return identifier.toLowerCase(Locale.ROOT).equals(identifier);
        }
    }
    ,
    MIXED{

        @Override
        public boolean isValid(String identifier) {
            Objects.requireNonNull(identifier);
            return true;
        }
    };


    public abstract boolean isValid(@NonNull String var1);
}

