/*
 * Decompiled with CFR 0.152.
 */
package internal.sql.lhod;

import internal.nbbrd.picocsv.Csv;
import internal.sql.lhod.TabDataColumn;
import internal.sql.lhod.TabDataFormatError;
import internal.sql.lhod.TabDataRemoteError;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

final class TabDataReader
implements Closeable {
    private static final String DELIMITER = "\t";
    private final Csv.Reader reader;
    private final List<TabDataColumn> columns;
    private final String[] currentRow;
    private boolean closed = false;

    static @NonNull TabDataReader of(@NonNull BufferedReader reader) throws IOException {
        Csv.Reader x = Csv.Reader.of(Csv.Format.RFC4180.toBuilder().delimiter('\t').build(), Csv.ReaderOptions.DEFAULT, reader, 8192);
        List<TabDataColumn> columns = TabDataReader.readColumnHeaders(x);
        return new TabDataReader(x, columns, new String[columns.size()]);
    }

    public boolean isClosed() throws IOException {
        return this.closed;
    }

    public boolean readNextRow() throws IOException {
        if (this.reader.readLine()) {
            if (!this.reader.readField()) {
                throw TabDataReader.parseError(this.reader);
            }
            int idx = 0;
            this.currentRow[idx++] = this.reader.toString();
            while (this.reader.readField()) {
                this.currentRow[idx++] = this.reader.toString();
            }
            return true;
        }
        return false;
    }

    public String get(int index) {
        return this.currentRow[index];
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.reader.close();
    }

    private static TabDataRemoteError parseError(Csv.Reader reader) throws IOException {
        if (!reader.readLine()) {
            throw new TabDataFormatError("Expected error on next row");
        }
        if (!reader.readField()) {
            throw new TabDataFormatError("Expected error code on next field");
        }
        String errorCode = reader.toString();
        if (!reader.readField()) {
            throw new TabDataFormatError("Expected error description on next field");
        }
        String errorMessage = reader.toString();
        try {
            return new TabDataRemoteError(errorMessage, Integer.parseInt(errorCode));
        }
        catch (NumberFormatException ex) {
            throw new TabDataFormatError("Cannot parse error code", ex);
        }
    }

    private static List<TabDataColumn> readColumnHeaders(Csv.Reader reader) throws IOException {
        List<String> names = TabDataReader.readHeader(reader, "names");
        List<String> types = TabDataReader.readHeader(reader, "types");
        if (names.size() != types.size()) {
            throw new TabDataFormatError(String.format("Invalid data type length: expected '%s', found '%s'", names.size(), types.size()));
        }
        ArrayList<TabDataColumn> result = new ArrayList<TabDataColumn>();
        for (int i = 0; i < names.size(); ++i) {
            try {
                result.add(new TabDataColumn(names.get(i), Integer.parseInt(types.get(i))));
                continue;
            }
            catch (NumberFormatException ex) {
                throw new TabDataFormatError("Cannot parse type code", ex);
            }
        }
        return result;
    }

    private static List<String> readHeader(Csv.Reader reader, String id) throws IOException {
        if (!reader.readLine()) {
            throw new TabDataFormatError(String.format("Expected header %s", id));
        }
        if (!reader.readField()) {
            throw TabDataReader.parseError(reader);
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(reader.toString());
        while (reader.readField()) {
            result.add(reader.toString());
        }
        return result;
    }

    @Generated
    public TabDataReader(Csv.Reader reader, List<TabDataColumn> columns, String[] currentRow) {
        this.reader = reader;
        this.columns = columns;
        this.currentRow = currentRow;
    }

    @Generated
    public List<TabDataColumn> getColumns() {
        return this.columns;
    }
}

