/*
 * Decompiled with CFR 0.152.
 */
package com.github.nullterminated.trylambda;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class Either<A, B> {
    private Either() {
    }

    public static <A, B> Either<A, B> left(A left) {
        return new Left(left);
    }

    public static <A, B> Either<A, B> right(B right) {
        return new Right(right);
    }

    public final boolean isLeft() {
        return this instanceof Left;
    }

    public final boolean isRight() {
        return this instanceof Right;
    }

    public abstract A getLeft();

    public abstract B getRight();

    public abstract void use(Consumer<A> var1, Consumer<B> var2);

    public abstract <X, Y> Either<X, Y> map(Function<A, X> var1, Function<B, Y> var2);

    public abstract <T> T reduce(Function<A, T> var1, Function<B, T> var2);

    public abstract Either<B, A> flip();

    public static final class Right<A, B>
    extends Either<A, B> {
        private final B right;

        private Right(B right) {
            if (right == null) {
                throw new IllegalArgumentException("right is null");
            }
            this.right = right;
        }

        @Override
        public A getLeft() {
            throw new UnsupportedOperationException("Cannot getLeft from Right.");
        }

        @Override
        public B getRight() {
            return this.right;
        }

        public int hashCode() {
            int hash = 3;
            hash = 41 * hash + Objects.hashCode(this.right);
            return hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && Objects.equals(this.getClass(), obj.getClass()) && Objects.equals(this.right, ((Right)obj).right);
        }

        public String toString() {
            return "Right{right=" + this.right + "}";
        }

        @Override
        public void use(Consumer<A> leftConsumer, Consumer<B> rightConsumer) {
            rightConsumer.accept(this.right);
        }

        @Override
        public <X, Y> Either<X, Y> map(Function<A, X> leftFunction, Function<B, Y> rightFunction) {
            return new Right<A, Y>(rightFunction.apply(this.right));
        }

        @Override
        public <T> T reduce(Function<A, T> leftFunction, Function<B, T> rightFunction) {
            return rightFunction.apply(this.right);
        }

        @Override
        public Either<B, A> flip() {
            return new Left(this.right);
        }
    }

    public static final class Left<A, B>
    extends Either<A, B> {
        private final A left;

        private Left(A left) {
            if (left == null) {
                throw new IllegalArgumentException("left is null");
            }
            this.left = left;
        }

        @Override
        public A getLeft() {
            return this.left;
        }

        @Override
        public B getRight() {
            throw new UnsupportedOperationException("Cannot getRight from Left.");
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + Objects.hashCode(this.left);
            return hash;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && Objects.equals(this.getClass(), obj.getClass()) && Objects.equals(this.left, ((Left)obj).left);
        }

        public String toString() {
            return "Left{left=" + this.left + "}";
        }

        @Override
        public void use(Consumer<A> leftConsumer, Consumer<B> rightConsumer) {
            leftConsumer.accept(this.left);
        }

        @Override
        public <X, Y> Either<X, Y> map(Function<A, X> leftFunction, Function<B, Y> rightFunction) {
            return new Left<X, B>(leftFunction.apply(this.left));
        }

        @Override
        public <T> T reduce(Function<A, T> leftFunction, Function<B, T> rightFunction) {
            return leftFunction.apply(this.left);
        }

        @Override
        public Either<B, A> flip() {
            return new Right(this.left);
        }
    }
}

