/*
 * Decompiled with CFR 0.152.
 */
package com.github.nullterminated.trylambda;

import com.github.nullterminated.trylambda.CheckedSupplier;
import com.github.nullterminated.trylambda.Either;
import com.github.nullterminated.trylambda.WrappedException;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Try {
    private Try() {
    }

    public static <T extends AutoCloseable, R> CheckedSupplier<R> trys(CheckedSupplier<T> supplier, Function<Exception, CheckedSupplier<R>> errorHandler, Function<T, CheckedSupplier<R>> function) {
        CheckedSupplier<Object> result;
        try (AutoCloseable resource = (AutoCloseable)supplier.gets();){
            Object value = function.apply(resource).gets();
            result = () -> value;
        }
        catch (WrappedException e) {
            throw e;
        }
        catch (Exception e) {
            result = errorHandler.apply(e);
        }
        return result;
    }

    public static <T extends AutoCloseable, R> CheckedSupplier<R> trys(CheckedSupplier<T> supplier, Function<T, CheckedSupplier<R>> function) {
        return Try.trys(supplier, e -> {
            throw WrappedException.wrap(e);
        }, function);
    }

    public static <R> Either<Exception, R> either(Supplier<R> supplier) {
        Either<Object, Object> result;
        try {
            result = Either.right(supplier.get());
        }
        catch (WrappedException e) {
            result = Either.left(e.getCause());
        }
        catch (Exception e) {
            result = Either.left(e);
        }
        return result;
    }

    public static <R> Either<Exception, R> either(CheckedSupplier<R> supplier) {
        return Try.either(supplier);
    }
}

