/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver;

import com.rodbate.httpserver.HttpServerInitializerFactory;
import com.rodbate.httpserver.common.RequestMappers;
import com.rodbate.httpserver.common.ServerConfig;
import com.rodbate.httpserver.common.StringUtil;
import com.rodbate.httpserver.upload.FileDeleteListener;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bootstrap {
    private static final Logger LOGGER = LoggerFactory.getLogger(Bootstrap.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main() throws Exception {
        long start = System.currentTimeMillis();
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        ServerConfig.initProperties();
        String portStr = ServerConfig.getProperty("port");
        if (StringUtil.isNull(portStr)) {
            throw new RuntimeException("port must not be null");
        }
        int port = Integer.valueOf(portStr);
        String hostname = ServerConfig.getProperty("hostname");
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)bootstrap.option(ChannelOption.SO_BACKLOG, (Object)1024)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true);
            ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new HttpServerInitializerFactory());
            Bootstrap.isBindPort(port);
            Channel channel = StringUtil.isNull(hostname) ? bootstrap.bind(port).sync().channel() : bootstrap.bind(hostname, port).sync().channel();
            Bootstrap.printLogo();
            RequestMappers.init();
            FileDeleteListener.init();
            LOGGER.info("========>>>>>>>> Http Server Start Up ! Using Time [{}MS]", (Object)(System.currentTimeMillis() - start));
            LOGGER.info("========>>>>>>>> Open your web browser and navigate to http://{}:{}", (Object)(StringUtil.isNull(hostname) ? "127.0.0.1" : hostname), (Object)port);
            channel.closeFuture().sync();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public static void isBindPort(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            LOGGER.error("========>>>>>>>> Fail to bind to the port[{}]", (Object)port);
            LOGGER.error("========>>>>>>>> Http server exist");
            System.exit(1);
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLogo() {
        StringBuilder logo = new StringBuilder();
        BufferedReader br = null;
        String separator = System.getProperty("line.separator", "\n");
        logo.append(separator);
        try {
            String line;
            InputStream is = ClassLoader.getSystemResourceAsStream("logo.txt");
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                logo.append(line);
                String line2 = br.readLine();
                if (line2 == null) {
                    logo.append("VERSION : ").append("1.0.3").append(separator);
                    continue;
                }
                logo.append(separator).append(line2).append(separator);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
        LOGGER.info(logo.toString());
    }
}

