/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.upload;

import com.rodbate.httpserver.upload.DiskFileItem;
import com.rodbate.httpserver.upload.FileDeleteListener;
import com.rodbate.httpserver.upload.FileItem;
import com.rodbate.httpserver.upload.FileItemFactory;
import java.io.File;
import java.io.IOException;

public class DiskFileItemFactory
implements FileItemFactory {
    private static final int DEFAULT_THRESHOLD = 10240;
    private int sizeThreshold = 10240;
    private File repository;
    private long fileExistDuration;

    public DiskFileItemFactory() {
        this(10240, null, 0L);
    }

    public DiskFileItemFactory(int sizeThreshold, File repository, long fileExistDuration) {
        this.sizeThreshold = sizeThreshold;
        this.repository = repository;
        this.fileExistDuration = fileExistDuration;
    }

    @Override
    public FileItem createItem(String fieldName, String contentType, String filename, boolean isFormField) {
        DiskFileItem fileItem = new DiskFileItem(contentType, fieldName, filename, isFormField, this.sizeThreshold, this.repository);
        if (!isFormField) {
            try {
                FileDeleteListener.register(fileItem.getTempFile(), this.fileExistDuration);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileItem;
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public void setSizeThreshold(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public File getRepository() {
        return this.repository;
    }

    public void setRepository(File repository) {
        this.repository = repository;
    }

    public long getFileExistDuration() {
        return this.fileExistDuration;
    }

    public void setFileExistDuration(long fileExistDuration) {
        this.fileExistDuration = fileExistDuration;
    }
}

