/*
 * Decompiled with CFR 0.152.
 */
package com.rodbate.httpserver.upload;

import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdOutputStream
extends OutputStream {
    private int sizeThreshold;
    private long writtenIndex;
    private boolean thresholdExceeded;

    public ThresholdOutputStream(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkReachThreshold(1);
        this.getStream().write(b);
        ++this.writtenIndex;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkReachThreshold(len);
        this.getStream().write(b, off, len);
        this.writtenIndex += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.getStream().flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getStream().close();
    }

    public int getSizeThreshold() {
        return this.sizeThreshold;
    }

    public long getByteCount() {
        return this.writtenIndex;
    }

    public boolean isThresholdExceeded() {
        return this.writtenIndex > (long)this.sizeThreshold;
    }

    protected void checkReachThreshold(int count) throws IOException {
        if (!this.thresholdExceeded && this.writtenIndex + (long)count > (long)this.sizeThreshold) {
            this.thresholdExceeded = true;
            this.reachThreshold();
        }
    }

    public void resetByteCount() {
        this.thresholdExceeded = false;
        this.writtenIndex = 0L;
    }

    protected abstract OutputStream getStream();

    protected abstract void reachThreshold() throws IOException;
}

