/*
 * Decompiled with CFR 0.152.
 */
package com.github.smallmenu.date;

import com.github.smallmenu.Fun;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strtotime {
    private static final List<DMatcher> DT_MATCHERS;
    private static final List<DMatcher> D_MATCHERS;

    public static long parse(String input) {
        if (input != null) {
            LocalDateTime ldt;
            for (DMatcher matcher : DT_MATCHERS) {
                ldt = matcher.tryConvert(input, null);
                if (ldt == null) continue;
                return ldt.atZone(ZoneId.systemDefault()).toEpochSecond();
            }
            for (DMatcher matcher : D_MATCHERS) {
                ldt = matcher.tryConvert(input, null);
                if (ldt == null) continue;
                return ldt.atZone(ZoneId.systemDefault()).toEpochSecond();
            }
        }
        return 0L;
    }

    public static long parse(String input, Long time) {
        if (input != null) {
            LocalDateTime ldt;
            for (DMatcher matcher : DT_MATCHERS) {
                ldt = matcher.tryConvert(input, time);
                if (ldt == null) continue;
                return ldt.atZone(ZoneId.systemDefault()).toEpochSecond();
            }
            for (DMatcher matcher : D_MATCHERS) {
                ldt = matcher.tryConvert(input, time);
                if (ldt == null) continue;
                return ldt.atZone(ZoneId.systemDefault()).toEpochSecond();
            }
        }
        return 0L;
    }

    static {
        D_MATCHERS = new LinkedList<DMatcher>();
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy-M-d")));
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd")));
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy/M/d")));
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd")));
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5")));
        D_MATCHERS.add(new DateFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d")));
        DT_MATCHERS = new LinkedList<DMatcher>();
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u70b9mm\u5206ss\u79d2")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss.SSS")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-M-d HH:m:s")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH\u65f6m\u5206s\u79d2")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH\u70b9m\u5206s\u79d2")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:m:s")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/M/d HH:m:s")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-M-d H:m:s")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u70b9m\u5206s\u79d2")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H:m:s")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/M/d H:m:s")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssz")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ssz")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ss'Z'")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ss")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSz")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ss.SSSz")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ss.SSS'Z'")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd'T'HH:mm:ss.SSS")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-M-d HH:m")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy-M-d H:m")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/M/d HH:m")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy/M/d H:m")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH\u70b9mm\u5206")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5 HH:mm")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH\u65f6m\u5206")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH\u70b9m\u5206")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u70b9m\u5206")));
        DT_MATCHERS.add(new DateTimeFormatMatcher(DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:m")));
        DT_MATCHERS.add(new DMatcher(){
            private final Pattern regex = Pattern.compile("[\\-\\+]?\\d+ (year|month|day|hour|minute|second|week)[s]?");

            @Override
            public LocalDateTime tryConvert(String input, Long time) {
                String exp = Fun.trim(input);
                Matcher matcher = this.regex.matcher(exp);
                if (!Fun.blank(exp) && matcher.find()) {
                    int t = Fun.toInt(exp.split(" ")[0]);
                    LocalDateTime ldt = LocalDateTime.now();
                    if (time != null) {
                        ldt = LocalDateTime.ofInstant(Instant.ofEpochSecond(Math.abs(time)), ZoneId.systemDefault());
                    }
                    if (t != 0) {
                        String type;
                        switch (type = matcher.group(1)) {
                            case "year": {
                                ldt = ldt.plusYears(t);
                                break;
                            }
                            case "month": {
                                ldt = ldt.plusMonths(t);
                                break;
                            }
                            case "day": {
                                ldt = ldt.plusDays(t);
                                break;
                            }
                            case "hour": {
                                ldt = ldt.plusHours(t);
                                break;
                            }
                            case "minute": {
                                ldt = ldt.plusMinutes(t);
                                break;
                            }
                            case "second": {
                                ldt = ldt.plusSeconds(t);
                                break;
                            }
                            case "week": {
                                ldt = ldt.plusWeeks(t);
                                break;
                            }
                        }
                    }
                    return ldt;
                }
                return null;
            }
        });
    }

    private static class DateFormatMatcher
    implements DMatcher {
        private final DateTimeFormatter dateFormat;

        DateFormatMatcher(DateTimeFormatter dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public LocalDateTime tryConvert(String input, Long time) {
            try {
                LocalDate ld = LocalDate.parse(input, this.dateFormat);
                return LocalDateTime.of(ld, LocalTime.MIN);
            }
            catch (DateTimeParseException ex) {
                return null;
            }
        }
    }

    private static class DateTimeFormatMatcher
    implements DMatcher {
        private final DateTimeFormatter dateFormat;

        DateTimeFormatMatcher(DateTimeFormatter dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public LocalDateTime tryConvert(String input, Long time) {
            try {
                return LocalDateTime.parse(input, this.dateFormat);
            }
            catch (DateTimeParseException ex) {
                return null;
            }
        }
    }

    public static interface DMatcher {
        public LocalDateTime tryConvert(String var1, Long var2);
    }
}

