/*
 * Decompiled with CFR 0.152.
 */
package com.github.thstock.djp;

import com.github.thstock.djp.DockerfileLine;
import com.github.thstock.djp.util.Tuple;
import com.github.thstock.djp.util.XStream;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dockerfile {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dockerfile.class);
    private static final String FROM = "FROM";
    private static final String LABEL = "LABEL";
    private static final String ENV = "ENV";
    private static final String RUN = "RUN";
    private static final String EXPOSE = "EXPOSE";
    private static final String STOPSIGNAL = "STOPSIGNAL";
    private static final String CMD = "CMD";
    private final String LC = "\\";
    private final ImmutableList<String> tokens = ImmutableList.of((Object)"#", (Object)"\\", (Object)"FROM", (Object)"LABEL", (Object)"ENV", (Object)"RUN", (Object)"EXPOSE", (Object)"STOPSIGNAL", (Object)"CMD");
    final ImmutableList<String> allLines;
    final ImmutableList<String> lines;
    private ImmutableList<DockerfileLine> tokenLines;
    private String from;
    private ImmutableMap<String, String> labels;
    private ImmutableMap<String, String> env;

    Dockerfile(File file, boolean strict) {
        this(Dockerfile.lines(file), strict);
    }

    Dockerfile(String content, boolean strict) {
        this(Dockerfile.lines(content), strict);
    }

    Dockerfile(ImmutableList<String> allLines, boolean strict) {
        this.allLines = allLines;
        this.lines = XStream.from(allLines).filterNot(in -> in.trim().isEmpty()).filterNot(in -> in.trim().startsWith("#")).toList();
        if (allLines.isEmpty() || this.lines.isEmpty()) {
            throw new IllegalStateException("Dockerfile cannot be empty");
        }
        ImmutableList<String> elements = Dockerfile.joindLines(this.lines, "\\");
        this.tokenLines = XStream.from(elements).map(DockerfileLine::from).toList();
        ImmutableList<String> invalids = XStream.from(this.tokenLines).map(DockerfileLine::getToken).filterNot(arg_0 -> this.tokens.contains(arg_0)).toList();
        if (!invalids.isEmpty()) {
            throw new IllegalStateException("invalid token(s): " + invalids);
        }
        try {
            this.from = XStream.from(this.tokenLines).filter(l -> l.isToken(FROM)).map(DockerfileLine::getValue).last();
        }
        catch (NoSuchElementException e) {
            if (strict) {
                throw new IllegalStateException("Dockerfile must start with FROM");
            }
            this.from = "";
        }
        this.labels = XStream.from(this.tokenLines).filter(l -> l.isToken(LABEL)).map(DockerfileLine::valueTokens).flatMap(in -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableList l = in;
            while (l.size() > 2) {
                ImmutableList strings2;
                int drop = 3;
                ImmutableList strings = XStream.from(l).take(drop).toList();
                String key = (String)strings.get(0);
                String equal = (String)strings.get(1);
                String value = (String)strings.get(2);
                String last = (String)XStream.from(l).take(4).last();
                if (last.equals(" ")) {
                    drop = 4;
                }
                if (!strict && equal.equals(" ") && value.equals("=")) {
                    strings2 = XStream.from(l).take(5).toList();
                    equal = value;
                    value = "= " + (String)strings2.get(4);
                    drop = 5;
                } else if (!strict && equal.equals("=") && value.equals("=")) {
                    strings2 = XStream.from(l).take(4).toList();
                    equal = value;
                    value = (String)strings2.get(2);
                    if (strings2.size() > 3) {
                        value = value + (String)strings2.get(3);
                    }
                    drop = 4;
                }
                if (!equal.equals("=")) {
                    throw new IllegalStateException("Syntax error - can't find = in \"" + value + "\". Must be of the form: name=value");
                }
                builder.add((Object)ImmutableList.of((Object)key, (Object)equal, (Object)value));
                l = XStream.from(l).drop(drop).toList();
            }
            return XStream.from(builder.build());
        }).toMap(Dockerfile::getObject);
        this.env = XStream.from(this.tokenLines).filter(l -> l.isToken(ENV)).map(DockerfileLine::valueTokens).flatMap(in -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            ImmutableList l = in;
            while (l.size() > 2) {
                if (l.contains((Object)"=")) {
                    int drop = 3;
                    ImmutableList strings = XStream.from(l).take(drop).toList();
                    String key = (String)strings.get(0);
                    String equal = (String)strings.get(1);
                    String value = (String)strings.get(2);
                    String last = (String)XStream.from(l).take(4).last();
                    if (last.equals(" ")) {
                        drop = 4;
                    }
                    builder.add((Object)ImmutableList.of((Object)key, (Object)equal, (Object)value));
                    l = XStream.from(l).drop(drop).toList();
                    continue;
                }
                builder.add((Object)ImmutableList.of((Object)in.get(0), (Object)"=", (Object)XStream.from(in).drop(2).mkString("")));
                l = ImmutableList.of();
            }
            return XStream.from(builder.build());
        }).toMap(Dockerfile::getObject);
    }

    static Tuple<String, String> getObject(ImmutableList<String> line) {
        String key = (String)line.get(0);
        String value = (String)line.get(2);
        return Tuple.of(key, value);
    }

    static ImmutableList<String> joindLines(ImmutableList<String> lines, String lc) {
        ImmutableList.Builder builder = ImmutableList.builder();
        String buff = "";
        for (int i = 0; i < lines.size(); ++i) {
            String l = (String)lines.get(i);
            String trim = l.trim();
            if (!trim.endsWith(lc)) {
                buff = buff + l;
                builder.add((Object)buff);
                buff = "";
                continue;
            }
            String substring = trim.substring(0, trim.length() - 1);
            buff = buff + substring + "\n";
        }
        return builder.build();
    }

    public String getFrom() {
        return this.from;
    }

    public String getCmdShell() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    public ImmutableList<String> getCmd() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    public ImmutableMap<Integer, String> getExpose() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    ImmutableMap<String, String> getEnv() {
        return this.env;
    }

    void getAdd() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getCopy() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getEntrypoint() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getVolume() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getUser() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getWorkdir() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getArg() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getOnbuild() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getStopsignal() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getHealthcheck() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    void getShell() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    public ImmutableList<String> getRunLines() {
        throw new UnsupportedOperationException("Will be implemented later");
    }

    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    private static ImmutableList<String> lines(String content) {
        return Dockerfile.toLines(CharSource.wrap((CharSequence)content));
    }

    private static ImmutableList<String> lines(File file) {
        return Dockerfile.toLines(Files.asCharSource((File)file, (Charset)StandardCharsets.UTF_8));
    }

    private static ImmutableList<String> toLines(CharSource charSource) {
        try {
            return charSource.readLines();
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static File resourceFile(String resouce) {
        URL resource = Resources.getResource((String)resouce);
        try {
            return new File(resource.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Dockerfile parse(String content) {
        return new Dockerfile(content, false);
    }

    public static Dockerfile parse(File file) {
        return new Dockerfile(file, false);
    }

    public static Dockerfile parseStrict(String content) {
        return new Dockerfile(content, true);
    }

    public static Dockerfile parseStrict(File file) {
        return new Dockerfile(file, true);
    }
}

