/*
 * Decompiled with CFR 0.152.
 */
package java2slice;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassInspector {
    private final ClassLoader loader;
    private Set<Class<?>> seqenceClassesNeeded = new HashSet();
    private Map<Class<?>, Map<String, ClassInfo>> propertiesMapMap = new HashMap();
    private ClassNotFoundException e = null;

    public Set<Class<?>> getSeqenceClassesNeeded() {
        return Collections.unmodifiableSet(this.seqenceClassesNeeded);
    }

    public ClassInspector(ClassLoader loader) {
        this.loader = loader;
    }

    private static String getterNameToPropertyName(String getterName) {
        if (getterName.startsWith("get")) {
            return getterName.substring(3, 4).toLowerCase() + getterName.substring(4);
        }
        if (getterName.startsWith("is")) {
            return getterName.substring(2, 3).toLowerCase() + getterName.substring(3);
        }
        throw new IllegalArgumentException(getterName + " must start with get/is");
    }

    private static String setterNameToPropertyName(String setterName) {
        if (setterName.startsWith("set")) {
            return setterName.substring(3, 4).toLowerCase() + setterName.substring(4);
        }
        throw new IllegalArgumentException(setterName + " must start with set");
    }

    public Map<String, ClassInfo> getProperties(Class clss) throws ClassNotFoundException {
        Map<String, ClassInfo> map = this.propertiesMapMap.get(clss);
        if (null != map) {
            return map;
        }
        Method[] methods = clss.getDeclaredMethods();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        for (int i = 0; i < methods.length; ++i) {
            String propName;
            Class<?> returnClass;
            Method method = methods[i];
            if (method.getParameterTypes() != null && method.getParameterTypes().length > 0 || !Modifier.isPublic(method.getModifiers()) || (returnClass = method.getReturnType()) == null || returnClass.equals(Void.class) || returnClass.equals(Void.TYPE) || returnClass.equals(Class.class) || !method.getName().startsWith("get") && !method.getName().startsWith("is") || (propName = ClassInspector.getterNameToPropertyName(method.getName())).equals("class")) continue;
            getters.put(propName, method);
        }
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (int i = 0; i < methods.length; ++i) {
            Class<?> returnClass;
            Method method = methods[i];
            if (method.getParameterTypes() == null || method.getParameterTypes().length != 1 || !Modifier.isPublic(method.getModifiers()) || (returnClass = method.getReturnType()) != null && !returnClass.equals(Void.class) && !returnClass.equals(Void.TYPE) || !method.getName().startsWith("set")) continue;
            String propName = ClassInspector.setterNameToPropertyName(method.getName());
            setters.put(propName, method);
        }
        map = new HashMap<String, ClassInfo>();
        for (Map.Entry entry : getters.entrySet()) {
            ClassInfo ci = new ClassInfo(((Method)entry.getValue()).getReturnType(), ((Method)entry.getValue()).getGenericReturnType());
            if (List.class.isAssignableFrom(((Method)entry.getValue()).getReturnType())) {
                List<Class<?>> paramClasses = ci.getGenericParamClasses();
                this.seqenceClassesNeeded.add(paramClasses.get(0));
            } else if (!setters.containsKey(entry.getKey())) continue;
            map.put((String)entry.getKey(), ci);
        }
        if (null != this.e) {
            throw this.e;
        }
        this.propertiesMapMap.put(clss, map);
        return map;
    }

    public class ClassInfo<T> {
        private final Class<T> propertyClass;
        private final ParameterizedType parType;
        private final List<Class<?>> genericParamClasses;

        private Class<?> loadClass(String s) {
            try {
                return ClassInspector.this.loader.loadClass(s);
            }
            catch (ClassNotFoundException ex) {
                ClassInspector.this.e = ex;
                Logger.getLogger(ClassInspector.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        public ClassInfo(Class<T> clss, Type pt) {
            this.propertyClass = clss;
            this.parType = pt != null && pt instanceof ParameterizedType ? (ParameterizedType)pt : null;
            this.genericParamClasses = new ArrayList();
            if (null != this.parType) {
                for (Type t : this.parType.getActualTypeArguments()) {
                    Object[] names = t.toString().split("[ ]+");
                    try {
                        String clssname = names[names.length - 1];
                        Class<?> parClss = ClassInspector.this.loader.loadClass(clssname);
                        this.genericParamClasses.add(parClss);
                    }
                    catch (ClassNotFoundException ex) {
                        System.err.println("clss=" + clss);
                        System.err.println("pt=" + pt);
                        System.err.println("names=" + Arrays.toString(names));
                        Logger.getLogger(ClassInspector.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }

        public Class<T> getPropertyClass() {
            return this.propertyClass;
        }

        public ParameterizedType getParType() {
            return this.parType;
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + Objects.hashCode(this.propertyClass);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ClassInfo other = (ClassInfo)obj;
            return Objects.equals(this.propertyClass, other.propertyClass);
        }

        public List<Class<?>> getGenericParamClasses() {
            return this.genericParamClasses;
        }
    }
}

