/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.connector;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.ISOZonedDateTimeSerializer;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.connector.ConnectorType;
import com.gooddata.sdk.model.connector.ProcessExecution;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.TreeMap;

public class Zendesk4ProcessExecution
implements ProcessExecution {
    private Boolean incremental;
    private Boolean reload;
    private Boolean recoverable;
    private Boolean recoveryInProgress;
    private Map<String, ZonedDateTime> startTimes;
    private DownloadParams downloadParams;

    @Override
    public ConnectorType getConnectorType() {
        return ConnectorType.ZENDESK4;
    }

    public Boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(Boolean incremental) {
        this.incremental = incremental;
    }

    public Boolean getReload() {
        return this.reload;
    }

    public void setReload(Boolean reload) {
        this.reload = reload;
    }

    public Boolean getRecoverable() {
        return this.recoverable;
    }

    public void setRecoverable(Boolean recoverable) {
        this.recoverable = recoverable;
    }

    public Boolean getRecoveryInProgress() {
        return this.recoveryInProgress;
    }

    public void setRecoveryInProgress(Boolean recoveryInProgress) {
        this.recoveryInProgress = recoveryInProgress;
    }

    @JsonAnyGetter
    @JsonSerialize(contentUsing=ISOZonedDateTimeSerializer.class)
    public Map<String, ZonedDateTime> getStartTimes() {
        return this.startTimes;
    }

    public void setStartTime(String resource, ZonedDateTime startTime) {
        Validate.notEmpty((CharSequence)resource, (String)"resource");
        Validate.notNull((Object)startTime, (String)"startTime");
        this.startTimes = this.startTimes == null ? new TreeMap() : this.startTimes;
        this.startTimes.put(resource + "StartDate", startTime);
    }

    @JsonIgnore
    public DownloadParams getDownloadParams() {
        if (this.downloadParams == null) {
            this.downloadParams = new DownloadParams();
        }
        return this.downloadParams;
    }

    @JsonProperty(value="downloadParams")
    private DownloadParams getDownloadParamsPlain() {
        return this.downloadParams;
    }

    public void setDownloadParams(DownloadParams downloadParams) {
        this.downloadParams = downloadParams;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DownloadParams {
        private Boolean useBackup;
        private Integer parallelWorkers;
        private Integer parallelBatchSeconds;

        public DownloadParams(Boolean useBackup, Integer parallelWorkers, Integer parallelBatchSeconds) {
            this.useBackup = useBackup;
            this.parallelWorkers = parallelWorkers;
            this.parallelBatchSeconds = parallelBatchSeconds;
        }

        public DownloadParams(Integer parallelWorkers, Integer parallelBatchSeconds) {
            this(null, parallelWorkers, parallelBatchSeconds);
        }

        public DownloadParams(Boolean useBackup) {
            this(useBackup, null, null);
        }

        private DownloadParams() {
        }

        @JsonProperty(value="useBackup")
        public Boolean getUseBackup() {
            return this.useBackup;
        }

        public void setUseBackup(Boolean useBackup) {
            this.useBackup = useBackup;
        }

        @JsonProperty(value="parallelWorkers")
        public Integer getParallelWorkers() {
            return this.parallelWorkers;
        }

        public void setParallelWorkers(Integer parallelWorkers) {
            this.parallelWorkers = parallelWorkers;
        }

        @JsonProperty(value="parallelBatchSeconds")
        public Integer getParallelBatchSeconds() {
            return this.parallelBatchSeconds;
        }

        public void setParallelBatchSeconds(Integer parallelBatchSeconds) {
            this.parallelBatchSeconds = parallelBatchSeconds;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

