/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.hierarchicalconfig;

import java.util.HashMap;
import java.util.Map;

public enum SourceType {
    CATALOG("catalog", null),
    CLIENT("client", "/gdc/domains/{domainName}/dataproducts/{dataProductId}/clients/{clientId}/config"),
    DATA_PRODUCT("data_product", "/gdc/domains/{domainName}/dataproducts/{dataProductId}/config"),
    SEGMENT("segment", "/gdc/domains/{domainName}/dataproducts/{dataProductId}/segments/{segmentId}/config"),
    DATAWAREHOUSE("datawarehouse", null),
    DOMAIN("domain", "/gdc/domains/{domainName}/config"),
    PROJECT("project", "/gdc/projects/{pid}/config"),
    PROJECT_GROUP("project_group", "/gdc/projectGroups/{projectGroup}/config"),
    USER("user", null);

    private static final Map<String, SourceType> lookup;
    private final String name;
    private final String apiUri;

    private SourceType(String name, String apiUri) {
        this.name = name;
        this.apiUri = apiUri;
    }

    public String getName() {
        return this.name;
    }

    public String getApiUri() {
        return this.apiUri;
    }

    public static SourceType get(String source) {
        return lookup.get(source);
    }

    public String toString() {
        return this.name;
    }

    static {
        lookup = new HashMap<String, SourceType>();
        for (SourceType c : SourceType.values()) {
            lookup.put(c.name, c);
        }
    }
}

