/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.afm.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.gooddata.sdk.common.util.GDLocalDate;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.executeafm.ObjQualifier;
import com.gooddata.sdk.model.executeafm.UriObjQualifier;
import com.gooddata.sdk.model.executeafm.afm.filter.DateFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.FilterItem;
import java.time.LocalDate;
import java.util.Objects;

@JsonRootName(value="absoluteDateFilter")
public class AbsoluteDateFilter
extends DateFilter {
    private static final long serialVersionUID = -1857726227400504182L;
    static final String NAME = "absoluteDateFilter";
    @GDLocalDate
    private final LocalDate from;
    @GDLocalDate
    private final LocalDate to;

    @JsonCreator
    public AbsoluteDateFilter(@JsonProperty(value="dataSet") ObjQualifier dataSet, @JsonProperty(value="from") LocalDate from, @JsonProperty(value="to") LocalDate to) {
        super(dataSet);
        this.from = from;
        this.to = to;
    }

    public LocalDate getFrom() {
        return this.from;
    }

    public LocalDate getTo() {
        return this.to;
    }

    @Override
    public FilterItem withObjUriQualifier(UriObjQualifier qualifier) {
        return new AbsoluteDateFilter(qualifier, this.from, this.to);
    }

    @Override
    @JsonIgnore
    public boolean isAllTimeSelected() {
        return this.getFrom() == null || this.getTo() == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbsoluteDateFilter that = (AbsoluteDateFilter)o;
        return super.equals(that) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.from, this.to, super.hashCode());
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

