/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.connector.IntegrationProcessStatus;

@JsonTypeName(value="integration")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Integration {
    public static final String URL = "/gdc/projects/{project}/connectors/{connector}/integration";
    private final IntegrationProcessStatus lastFinishedProcess;
    private final IntegrationProcessStatus lastSuccessfulProcess;
    private final IntegrationProcessStatus runningProcess;
    private String projectTemplate;
    private boolean active;

    public Integration(String projectTemplate) {
        this(projectTemplate, true, null, null, null);
    }

    @JsonCreator
    Integration(@JsonProperty(value="projectTemplate") String projectTemplate, @JsonProperty(value="active") boolean active, @JsonProperty(value="lastFinishedProcess") IntegrationProcessStatus lastFinishedProcess, @JsonProperty(value="lastSuccessfulProcess") IntegrationProcessStatus lastSuccessfulProcess, @JsonProperty(value="runningProcess") IntegrationProcessStatus runningProcess) {
        this.projectTemplate = (String)Validate.notEmpty((CharSequence)projectTemplate, (String)"projectTemplate");
        this.active = active;
        this.lastFinishedProcess = lastFinishedProcess;
        this.lastSuccessfulProcess = lastSuccessfulProcess;
        this.runningProcess = runningProcess;
    }

    public String getProjectTemplate() {
        return this.projectTemplate;
    }

    public void setProjectTemplate(String projectTemplate) {
        this.projectTemplate = (String)Validate.notEmpty((CharSequence)projectTemplate, (String)"projectTemplate");
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @JsonIgnore
    public IntegrationProcessStatus getLastFinishedProcess() {
        return this.lastFinishedProcess;
    }

    @JsonIgnore
    public IntegrationProcessStatus getLastSuccessfulProcess() {
        return this.lastSuccessfulProcess;
    }

    @JsonIgnore
    public IntegrationProcessStatus getRunningProcess() {
        return this.runningProcess;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

