/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.dataload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="outputStage")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OutputStage {
    public static final String URI = "/gdc/dataload/projects/{id}/outputStage";
    private static final String SELF_LINK = "self";
    private static final String OUTPUT_STAGE_DIFF = "outputStageDiff";
    private static final String DATALOAD_PROCESS = "dataloadProcess";
    private final Map<String, String> links;
    private String schema;
    private String clientId;
    private String outputStagePrefix;

    @JsonCreator
    private OutputStage(@JsonProperty(value="schema") String schema, @JsonProperty(value="clientId") String clientId, @JsonProperty(value="outputStagePrefix") String outputStagePrefix, @JsonProperty(value="links") Map<String, String> links) {
        this.schema = schema;
        this.clientId = clientId;
        this.outputStagePrefix = outputStagePrefix;
        this.links = links;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonProperty(value="schema")
    public String getSchemaUri() {
        return this.schema;
    }

    @JsonProperty(value="schema")
    public void setSchemaUri(String schemaUri) {
        this.schema = schemaUri;
    }

    public boolean hasSchemaUri() {
        return this.schema != null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public boolean hasClientId() {
        return this.clientId != null;
    }

    public String getOutputStagePrefix() {
        return this.outputStagePrefix;
    }

    public void setOutputStagePrefix(String outputStagePrefix) {
        this.outputStagePrefix = outputStagePrefix;
    }

    public boolean hasOutputStagePrefix() {
        return this.outputStagePrefix != null;
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(SELF_LINK);
    }

    @JsonIgnore
    public String getOutputStageDiffUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(OUTPUT_STAGE_DIFF);
    }

    @JsonIgnore
    public String getDataloadProcessUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(DATALOAD_PROCESS);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

