/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.dataload.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.dataload.processes.ProcessType;
import com.gooddata.sdk.model.util.UriHelper;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="process")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataloadProcess {
    public static final String URI = "/gdc/projects/{projectId}/dataload/processes/{processId}";
    private static final String SELF_LINK = "self";
    private static final String EXECUTIONS_LINK = "executions";
    private String name;
    private String type;
    private Set<String> executables;
    private Map<String, String> links;
    private String path;

    public DataloadProcess(String name, String type) {
        this.name = (String)Validate.notEmpty((CharSequence)name, (String)"name");
        this.type = (String)Validate.notEmpty((CharSequence)type, (String)"type");
    }

    public DataloadProcess(String name, String type, String appstorePath) {
        this(name, type);
        this.path = appstorePath;
    }

    public DataloadProcess(String name, ProcessType type) {
        this(name, ((ProcessType)((Object)Validate.notNull((Object)((Object)type), (String)"type"))).toString());
    }

    @JsonCreator
    private DataloadProcess(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="executables") Set<String> executables, @JsonProperty(value="links") Map<String, String> links) {
        this(name, type);
        this.executables = executables != null ? Collections.unmodifiableSet(executables) : null;
        this.links = links;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @JsonIgnore
    public Set<String> getExecutables() {
        return this.executables;
    }

    @JsonIgnore
    public String getUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(SELF_LINK);
    }

    @JsonIgnore
    public String getId() {
        return UriHelper.getLastUriPart(this.getUri());
    }

    @JsonIgnore
    public String getExecutionsUri() {
        return (String)((Map)Validate.notNullState(this.links, (String)"links")).get(EXECUTIONS_LINK);
    }

    @JsonIgnore
    public String getSourceUri() {
        return this.getUri() + "/source";
    }

    public void validateExecutable(String executable) {
        if (this.getExecutables() != null && !this.getExecutables().isEmpty() && !this.getExecutables().contains(executable)) {
            throw new IllegalArgumentException("Executable " + executable + " not found in process executables " + String.valueOf(this.getExecutables()));
        }
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

