/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.dataset;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.dataset.DatasetNotFoundException;
import com.gooddata.sdk.model.md.Meta;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@JsonTypeName(value="dataSetsInfo")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
public class UploadsInfo {
    public static final String URI = "/gdc/md/{projectId}/data/sets";
    private final Map<String, DataSet> datasets = new HashMap<String, DataSet>();

    UploadsInfo(@JsonProperty(value="sets") Collection<DataSet> datasets) {
        if (datasets != null) {
            for (DataSet dataset : datasets) {
                this.datasets.put(dataset.getDatasetId(), dataset);
            }
        }
    }

    public DataSet getDataSet(String datasetId) {
        Validate.notEmpty((CharSequence)datasetId, (String)"datasetId");
        DataSet dataSet = this.datasets.get(datasetId);
        if (dataSet != null) {
            return dataSet;
        }
        throw new DatasetNotFoundException(datasetId);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DataSet {
        private final Meta meta;
        private final String datasetUploadsUri;
        private final LastUpload lastUpload;

        private DataSet(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="dataUploads") String datasetUploadsUri, @JsonProperty(value="lastUpload") LastUpload lastUpload) {
            this.meta = meta;
            this.datasetUploadsUri = datasetUploadsUri;
            this.lastUpload = lastUpload;
        }

        public String getDatasetId() {
            return this.meta.getIdentifier();
        }

        public String getUploadsUri() {
            return this.datasetUploadsUri;
        }

        public String getLastUploadUri() {
            return this.lastUpload.uri;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonTypeName(value="dataUploadShort")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    private static class LastUpload {
        private final String uri;

        private LastUpload(@JsonProperty(value="uri") String uri) {
            this.uri = uri;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
        }
    }
}

