/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.executeafm.resultspec;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.executeafm.resultspec.Dimension;
import com.gooddata.sdk.model.executeafm.resultspec.SortItem;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResultSpec {
    private List<Dimension> dimensions;
    private List<SortItem> sorts;

    @JsonCreator
    public ResultSpec(@JsonProperty(value="dimensions") List<Dimension> dimensions, @JsonProperty(value="sorts") List<SortItem> sorts) {
        this.dimensions = dimensions;
        this.sorts = sorts;
    }

    public ResultSpec() {
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public List<SortItem> getSorts() {
        return this.sorts;
    }

    public void setSorts(List<SortItem> sorts) {
        this.sorts = sorts;
    }

    public ResultSpec addDimension(Dimension dimension) {
        if (this.dimensions == null) {
            this.setDimensions(new ArrayList<Dimension>());
        }
        this.dimensions.add((Dimension)Validate.notNull((Object)dimension, (String)"dimension"));
        return this;
    }

    public ResultSpec addSort(SortItem sort) {
        if (this.sorts == null) {
            this.setSorts(new ArrayList<SortItem>());
        }
        this.sorts.add((SortItem)Validate.notNull((Object)sort, (String)"sort"));
        return this;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

