/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.md.Attribute;
import com.gooddata.sdk.model.md.DisplayForm;
import com.gooddata.sdk.model.md.report.GridElement;
import com.gooddata.sdk.model.md.report.Total;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@JsonTypeName(value="attribute")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AttributeInGrid
implements GridElement,
Serializable {
    private static final long serialVersionUID = 9061580138440068825L;
    private final String uri;
    private final String alias;
    private final List<List<String>> totals;

    @JsonCreator
    AttributeInGrid(@JsonProperty(value="uri") String uri, @JsonProperty(value="totals") List<List<String>> totals, @JsonProperty(value="alias") String alias) {
        this.uri = uri;
        this.alias = alias;
        this.totals = totals;
    }

    public AttributeInGrid(String uri, String alias) {
        this(uri, new ArrayList<List<String>>(), alias);
    }

    public AttributeInGrid(String uri, String alias, List<List<Total>> totals) {
        this(uri, alias);
        Validate.notNull(totals, (String)"totals");
        for (List<Total> totalList : totals) {
            ArrayList totalStringList = new ArrayList(totalList.size());
            totalStringList.addAll(totalList.stream().map(Total::toString).collect(Collectors.toList()));
            this.totals.add(totalStringList);
        }
    }

    public AttributeInGrid(DisplayForm displayForm) {
        this((String)Validate.notNull((Object)((DisplayForm)Validate.notNull((Object)displayForm, (String)"displayForm")).getUri(), (String)"uri"), ((DisplayForm)Validate.notNull((Object)displayForm, (String)"displayForm")).getTitle());
    }

    public AttributeInGrid(DisplayForm displayForm, String alias) {
        this((String)Validate.notNull((Object)((DisplayForm)Validate.notNull((Object)displayForm, (String)"displayForm")).getUri(), (String)"uri"), alias);
    }

    public AttributeInGrid(Attribute attribute) {
        this(((Attribute)Validate.notNull((Object)attribute, (String)"attribute")).getDefaultDisplayForm(), ((Attribute)Validate.notNull((Object)attribute, (String)"attribute")).getTitle());
    }

    public AttributeInGrid(Attribute attribute, String alias) {
        this(((Attribute)Validate.notNull((Object)attribute, (String)"attribute")).getDefaultDisplayForm(), alias);
    }

    @JsonProperty(value="totals")
    public List<List<String>> getStringTotals() {
        return this.totals;
    }

    @JsonIgnore
    public List<List<Total>> getTotals() {
        ArrayList<List<Total>> enumTotals = new ArrayList<List<Total>>(this.totals.size());
        for (List<String> totalList : this.totals) {
            ArrayList totalEnumList = new ArrayList(totalList.size());
            totalEnumList.addAll(totalList.stream().map(Total::of).collect(Collectors.toList()));
            enumTotals.add(totalEnumList);
        }
        return enumTotals;
    }

    public String getUri() {
        return this.uri;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

