/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.sdk.model.md.Meta;
import com.gooddata.sdk.model.md.report.Filter;
import com.gooddata.sdk.model.md.report.Grid;
import com.gooddata.sdk.model.md.report.GridElement;
import com.gooddata.sdk.model.md.report.MetricElement;
import com.gooddata.sdk.model.md.report.ReportDefinition;
import com.gooddata.sdk.model.md.report.ReportDefinitionContent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OneNumberReportDefinitionContent
extends ReportDefinitionContent {
    public static final String FORMAT = "oneNumber";
    private static final long serialVersionUID = 5479509323034916986L;
    private final OneNumberVisualization oneNumber;

    @JsonCreator
    private OneNumberReportDefinitionContent(@JsonProperty(value="format") String format, @JsonProperty(value="grid") Grid grid, @JsonProperty(value="oneNumber") OneNumberVisualization oneNumber, @JsonProperty(value="filters") Collection<Filter> filters) {
        super(format, grid, filters);
        this.oneNumber = oneNumber;
    }

    OneNumberReportDefinitionContent(Grid grid, String description, Collection<Filter> filters) {
        super(FORMAT, grid, filters);
        this.oneNumber = new OneNumberVisualization(new OneNumberLabels(description));
    }

    public static ReportDefinition create(String title, List<GridElement> columns, List<GridElement> rows, List<MetricElement> metrics) {
        return OneNumberReportDefinitionContent.create(title, columns, rows, metrics, Collections.emptyList());
    }

    public static ReportDefinition create(String title, List<GridElement> columns, List<GridElement> rows, List<MetricElement> metrics, Collection<Filter> filters) {
        return new ReportDefinition(new Meta(title), (ReportDefinitionContent)new OneNumberReportDefinitionContent(new Grid(columns, rows, metrics), title, filters));
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    public OneNumberVisualization getOneNumber() {
        return this.oneNumber;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class OneNumberVisualization
    implements Serializable {
        private static final long serialVersionUID = 1105233720917978784L;
        private final OneNumberLabels labels;

        @JsonCreator
        private OneNumberVisualization(@JsonProperty(value="labels") OneNumberLabels labels) {
            this.labels = labels;
        }

        public OneNumberLabels getLabels() {
            return this.labels;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class OneNumberLabels
    implements Serializable {
        private static final long serialVersionUID = 6464599509495095669L;
        private final String description;

        @JsonCreator
        private OneNumberLabels(@JsonProperty(value="description") String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

