/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.md.visualization;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.executeafm.Execution;
import com.gooddata.sdk.model.executeafm.afm.Afm;
import com.gooddata.sdk.model.executeafm.afm.AttributeItem;
import com.gooddata.sdk.model.executeafm.afm.MeasureItem;
import com.gooddata.sdk.model.executeafm.afm.NativeTotalItem;
import com.gooddata.sdk.model.executeafm.afm.SimpleMeasureDefinition;
import com.gooddata.sdk.model.executeafm.afm.filter.CompatibilityFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.DateFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.ExtendedFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.FilterItem;
import com.gooddata.sdk.model.executeafm.afm.filter.MeasureValueFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.NegativeAttributeFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.PositiveAttributeFilter;
import com.gooddata.sdk.model.executeafm.afm.filter.RankingFilter;
import com.gooddata.sdk.model.executeafm.resultspec.Dimension;
import com.gooddata.sdk.model.executeafm.resultspec.ResultSpec;
import com.gooddata.sdk.model.executeafm.resultspec.SortItem;
import com.gooddata.sdk.model.executeafm.resultspec.TotalItem;
import com.gooddata.sdk.model.md.report.Total;
import com.gooddata.sdk.model.md.visualization.Bucket;
import com.gooddata.sdk.model.md.visualization.CollectionType;
import com.gooddata.sdk.model.md.visualization.Measure;
import com.gooddata.sdk.model.md.visualization.VisualizationAttribute;
import com.gooddata.sdk.model.md.visualization.VisualizationClass;
import com.gooddata.sdk.model.md.visualization.VisualizationObject;
import com.gooddata.sdk.model.md.visualization.VisualizationType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class VisualizationConverter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static Execution convertToExecution(VisualizationObject visualizationObject, Function<String, VisualizationClass> visualizationClassGetter) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull(visualizationClassGetter, (String)"visualizationClassGetter");
        return VisualizationConverter.convertToExecution(visualizationObject, visualizationClassGetter.apply(visualizationObject.getVisualizationClassUri()));
    }

    public static Execution convertToExecution(VisualizationObject visualizationObject, VisualizationClass visualizationClass) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull((Object)visualizationClass, (String)"visualizationClass");
        ResultSpec resultSpec = VisualizationConverter.convertToResultSpec(visualizationObject, visualizationClass);
        Afm afm = VisualizationConverter.convertToAfm(visualizationObject);
        return new Execution(afm, resultSpec);
    }

    public static Execution convertToExecutionWithTotals(VisualizationObject visualizationObject, Function<String, VisualizationClass> visualizationClassGetter) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull(visualizationClassGetter, (String)"visualizationClassGetter");
        return VisualizationConverter.convertToExecutionWithTotals(visualizationObject, visualizationClassGetter.apply(visualizationObject.getVisualizationClassUri()));
    }

    public static Execution convertToExecutionWithTotals(VisualizationObject visualizationObject, VisualizationClass visualizationClass) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull((Object)visualizationClass, (String)"visualizationClass");
        ResultSpec resultSpec = VisualizationConverter.convertToResultSpecWithTotals(visualizationObject, visualizationClass);
        Afm afm = VisualizationConverter.convertToAfmWithNativeTotals(visualizationObject);
        return new Execution(afm, resultSpec);
    }

    public static Afm convertToAfm(VisualizationObject visualizationObject) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        VisualizationObject visualizationObjectWithoutTotals = VisualizationConverter.removeTotals(visualizationObject);
        return VisualizationConverter.convertToAfmWithNativeTotals(visualizationObjectWithoutTotals);
    }

    public static Afm convertToAfmWithNativeTotals(VisualizationObject visualizationObject) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        List<AttributeItem> attributes = VisualizationConverter.convertAttributes(visualizationObject.getAttributes());
        List<CompatibilityFilter> filters = VisualizationConverter.convertFilters(visualizationObject.getFilters());
        List<MeasureItem> measures = VisualizationConverter.convertMeasures(visualizationObject.getMeasures());
        List<NativeTotalItem> totals = VisualizationConverter.convertNativeTotals(visualizationObject);
        return new Afm(attributes, filters, measures, totals);
    }

    public static ResultSpec convertToResultSpec(VisualizationObject visualizationObject, Function<String, VisualizationClass> visualizationClassGetter) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull(visualizationClassGetter, (String)"visualizationClassGetter");
        return VisualizationConverter.convertToResultSpec(visualizationObject, visualizationClassGetter.apply(visualizationObject.getVisualizationClassUri()));
    }

    public static ResultSpec convertToResultSpec(VisualizationObject visualizationObject, VisualizationClass visualizationClass) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull((Object)visualizationClass, (String)"visualizationClass");
        VisualizationObject visualizationObjectWithoutTotals = VisualizationConverter.removeTotals(visualizationObject);
        return VisualizationConverter.convertToResultSpecWithTotals(visualizationObjectWithoutTotals, visualizationClass);
    }

    public static ResultSpec convertToResultSpecWithTotals(VisualizationObject visualizationObject, Function<String, VisualizationClass> visualizationClassGetter) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull(visualizationClassGetter, (String)"visualizationClassGetter");
        return VisualizationConverter.convertToResultSpecWithTotals(visualizationObject, visualizationClassGetter.apply(visualizationObject.getVisualizationClassUri()));
    }

    public static ResultSpec convertToResultSpecWithTotals(VisualizationObject visualizationObject, VisualizationClass visualizationClass) {
        Validate.notNull((Object)visualizationObject, (String)"visualizationObject");
        Validate.notNull((Object)visualizationClass, (String)"visualizationClass");
        Validate.isTrue((boolean)visualizationObject.getVisualizationClassUri().equals(visualizationClass.getUri()), (String)"visualizationClass URI does not match the URI within visualizationObject, you're trying to create ResultSpec for incompatible objects");
        List<SortItem> sorts = VisualizationConverter.getSorting(visualizationObject);
        List<Dimension> dimensions = VisualizationConverter.getDimensions(visualizationObject, visualizationClass.getVisualizationType());
        return new ResultSpec(dimensions, sorts);
    }

    static List<SortItem> getSorting(VisualizationObject visualizationObject) {
        try {
            List<SortItem> sorts = VisualizationConverter.parseSorting(visualizationObject.getProperties());
            if (sorts != null) {
                return sorts;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static List<SortItem> parseSorting(String properties) throws Exception {
        JsonNode jsonProperties = VisualizationConverter.parseProperties(properties);
        JsonNode nodeSortItems = jsonProperties.get("sortItems");
        TypeReference<List<SortItem>> mapType = new TypeReference<List<SortItem>>(){};
        return (List)MAPPER.convertValue((Object)nodeSortItems, (TypeReference)mapType);
    }

    private static VisualizationObject removeTotals(VisualizationObject visualizationObject) {
        List<Bucket> bucketsWithoutTotals = visualizationObject.getBuckets().stream().map(bucket -> new Bucket(bucket.getLocalIdentifier(), bucket.getItems())).collect(Collectors.toList());
        return visualizationObject.withBuckets(bucketsWithoutTotals);
    }

    private static List<Dimension> getDimensions(VisualizationObject visualizationObject, VisualizationType visualizationType) {
        switch (visualizationType) {
            case COLUMN: 
            case BAR: {
                return VisualizationConverter.getDimensionsForStacked(visualizationObject, CollectionType.STACK, CollectionType.VIEW);
            }
            case LINE: {
                return VisualizationConverter.getDimensionsForStacked(visualizationObject, CollectionType.SEGMENT, CollectionType.TREND);
            }
            case PIE: {
                return VisualizationConverter.getDimensionsForPie(visualizationObject);
            }
        }
        return VisualizationConverter.getDimensionsForTable(visualizationObject);
    }

    private static List<Dimension> getDimensionsForPie(VisualizationObject visualizationObject) {
        VisualizationAttribute attribute = visualizationObject.getView();
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (visualizationObject.hasMeasures()) {
            dimensions.add(new Dimension("measureGroup"));
        }
        if (attribute != null) {
            dimensions.add(new Dimension(attribute.getLocalIdentifier()));
        }
        return dimensions;
    }

    private static List<Dimension> getDimensionsForStacked(VisualizationObject visualizationObject, CollectionType stackBy, CollectionType viewBy) {
        VisualizationAttribute stack = visualizationObject.getAttributeFromCollection(stackBy);
        VisualizationAttribute view = visualizationObject.getAttributeFromCollection(viewBy);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (stack != null) {
            dimensions.add(new Dimension(stack.getLocalIdentifier()));
            ArrayList<String> dimensionItems = new ArrayList<String>();
            if (view != null) {
                dimensionItems.add(view.getLocalIdentifier());
            }
            if (visualizationObject.hasMeasures()) {
                dimensionItems.add("measureGroup");
            }
            if (!dimensionItems.isEmpty()) {
                dimensions.add(new Dimension(dimensionItems));
            }
        } else {
            if (visualizationObject.hasMeasures()) {
                dimensions.add(new Dimension("measureGroup"));
            }
            if (view != null) {
                dimensions.add(new Dimension(view.getLocalIdentifier()));
            }
        }
        return dimensions;
    }

    private static List<Dimension> getDimensionsForTable(VisualizationObject visualizationObject) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        List<VisualizationAttribute> attributes = visualizationObject.getAttributes();
        List<TotalItem> totals = visualizationObject.getTotals();
        if (!attributes.isEmpty()) {
            Dimension attributeDimension = new Dimension(attributes.stream().map(AttributeItem::getLocalIdentifier).collect(Collectors.toList()));
            if (!totals.isEmpty()) {
                attributeDimension.setTotals(new HashSet<TotalItem>(totals));
            }
            dimensions.add(attributeDimension);
        } else {
            dimensions.add(new Dimension(new ArrayList<String>()));
        }
        if (visualizationObject.hasMeasures()) {
            dimensions.add(new Dimension("measureGroup"));
        }
        return dimensions;
    }

    private static JsonNode parseProperties(String properties) throws Exception {
        return (JsonNode)MAPPER.readValue(properties, JsonNode.class);
    }

    private static List<AttributeItem> convertAttributes(List<VisualizationAttribute> attributes) {
        return attributes.stream().map(AttributeItem.class::cast).collect(Collectors.toList());
    }

    private static List<CompatibilityFilter> convertFilters(List<ExtendedFilter> filters) {
        if (filters == null) {
            return new ArrayList<CompatibilityFilter>();
        }
        List<ExtendedFilter> validFilters = VisualizationConverter.removeIrrelevantFilters(filters);
        return VisualizationConverter.getCompatibilityFilters(validFilters);
    }

    private static List<MeasureItem> convertMeasures(List<Measure> measures) {
        return measures.stream().map(VisualizationConverter::removeFormat).map(VisualizationConverter::getAfmMeasure).map(VisualizationConverter::convertMeasureFilters).collect(Collectors.toList());
    }

    private static Measure removeFormat(Measure measure) {
        if (measure.hasComputeRatio()) {
            measure.setFormat("");
        }
        return measure;
    }

    private static MeasureItem getAfmMeasure(Measure measure) {
        String alias;
        String usedTitle = alias = measure.getAlias();
        if ((alias == null || alias.isEmpty()) && measure.getTitle() != null) {
            usedTitle = measure.getTitle();
        }
        return new MeasureItem(measure.getDefinition(), measure.getLocalIdentifier(), usedTitle, measure.getFormat());
    }

    private static MeasureItem convertMeasureFilters(MeasureItem measure) {
        if (measure.getDefinition() instanceof SimpleMeasureDefinition) {
            List<FilterItem> filters = ((SimpleMeasureDefinition)measure.getDefinition()).getFilters();
            List<FilterItem> validFilters = filters == null ? new ArrayList<FilterItem>() : VisualizationConverter.removeIrrelevantFilters(filters);
            ((SimpleMeasureDefinition)measure.getDefinition()).setFilters(validFilters);
        }
        return measure;
    }

    private static List<CompatibilityFilter> getCompatibilityFilters(List<ExtendedFilter> filters) {
        return filters.stream().map(CompatibilityFilter.class::cast).collect(Collectors.toList());
    }

    private static <T> List<T> removeIrrelevantFilters(List<T> filters) {
        return filters.stream().filter(f -> {
            if (f instanceof DateFilter) {
                return !((DateFilter)f).isAllTimeSelected();
            }
            if (f instanceof MeasureValueFilter) {
                return ((MeasureValueFilter)f).getCondition() != null;
            }
            if (f instanceof NegativeAttributeFilter) {
                return !((NegativeAttributeFilter)f).isAllSelected();
            }
            return f instanceof PositiveAttributeFilter || f instanceof RankingFilter;
        }).collect(Collectors.toList());
    }

    private static List<NativeTotalItem> convertNativeTotals(VisualizationObject visualizationObject) {
        List<Bucket> attributeBuckets = VisualizationConverter.getAttributeBuckets(visualizationObject);
        List<String> attributeIds = VisualizationConverter.getIdsFromAttributeBuckets(attributeBuckets);
        return attributeBuckets.stream().filter(bucket -> bucket.getTotals() != null).flatMap(bucket -> bucket.getTotals().stream()).filter(totalItem -> VisualizationConverter.isNativeTotal(totalItem) && attributeIds.contains(totalItem.getAttributeIdentifier())).map(totalItem -> VisualizationConverter.convertToNativeTotalItem(totalItem, attributeIds)).collect(Collectors.toList());
    }

    private static NativeTotalItem convertToNativeTotalItem(TotalItem totalItem, List<String> attributeIds) {
        int attributeIdx = attributeIds.indexOf(totalItem.getAttributeIdentifier());
        return new NativeTotalItem(totalItem.getMeasureIdentifier(), new ArrayList<String>(attributeIds.subList(0, attributeIdx)));
    }

    private static List<Bucket> getAttributeBuckets(VisualizationObject visualizationObject) {
        return visualizationObject.getBuckets().stream().filter(bucket -> bucket.getItems().stream().allMatch(AttributeItem.class::isInstance)).collect(Collectors.toList());
    }

    private static List<String> getIdsFromAttributeBuckets(List<Bucket> attributeBuckets) {
        return attributeBuckets.stream().flatMap(bucket -> bucket.getItems().stream().map(AttributeItem.class::cast).map(AttributeItem::getLocalIdentifier)).collect(Collectors.toList());
    }

    private static boolean isNativeTotal(TotalItem totalItem) {
        return totalItem.getType() != null && Total.NAT.name().equals(totalItem.getType().toUpperCase());
    }
}

