/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.model.project;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.sdk.common.util.BooleanDeserializer;
import com.gooddata.sdk.common.util.BooleanStringSerializer;
import com.gooddata.sdk.common.util.GoodDataToStringBuilder;
import com.gooddata.sdk.model.md.Meta;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="projectRole")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Role {
    public static final String URI = "/gdc/projects/{projectId}/roles/{roleId}";
    private static final String SELF_LINK = "self";
    @JsonDeserialize(contentUsing=BooleanDeserializer.class)
    @JsonSerialize(contentUsing=BooleanStringSerializer.class)
    private final Map<String, Boolean> permissions;
    private final Meta meta;
    private final Map<String, String> links;

    @JsonCreator
    Role(@JsonProperty(value="permissions") Map<String, Boolean> permissions, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="links") Map<String, String> links) {
        this.permissions = permissions == null ? new HashMap() : permissions;
        this.meta = meta == null ? new Meta(null) : meta;
        this.links = links == null ? new HashMap() : links;
    }

    public Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions.keySet());
    }

    public Set<String> getGrantedPermissions() {
        return this.permissions.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public boolean hasPermissionGranted(String permission) {
        return this.permissions.get(permission);
    }

    public String getTitle() {
        return this.meta.getTitle();
    }

    public String getIdentifier() {
        return this.meta.getIdentifier();
    }

    @JsonIgnore
    public String getUri() {
        return this.links.get(SELF_LINK);
    }

    public void setUri(String uri) {
        this.links.put(SELF_LINK, uri);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        if (!this.permissions.equals(role.permissions)) {
            return false;
        }
        return !(this.getIdentifier() == null ? role.getIdentifier() != null : !this.getIdentifier().equals(role.getIdentifier()));
    }

    public int hashCode() {
        int result = this.permissions.hashCode();
        result = 31 * result + (this.getIdentifier() != null ? this.getIdentifier().hashCode() : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

