/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.gdc;

import com.github.sardine.Sardine;
import com.github.sardine.impl.SardineImpl;
import com.gooddata.UriPrefixer;
import com.gooddata.gdc.DataStoreException;
import com.gooddata.gdc.GdcService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Locale;
import org.apache.commons.lang.Validate;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class DataStoreService {
    private final Sardine sardine;
    private final GdcService gdcService;
    private final URI gdcUri;
    private UriPrefixer prefixer;

    public DataStoreService(HttpClient httpClient, GdcService gdcService, String gdcUri) {
        this.gdcService = com.gooddata.util.Validate.notNull(gdcService, "gdcService");
        this.gdcUri = URI.create(com.gooddata.util.Validate.notEmpty(gdcUri, "gdcUri"));
        this.sardine = new SardineImpl((HttpClientBuilder)new CustomHttpClientBuilder(httpClient));
    }

    private UriPrefixer getPrefixer() {
        if (this.prefixer == null) {
            String uriString = this.gdcService.getGdc().getUserStagingLink();
            URI uri = URI.create(uriString);
            this.prefixer = new UriPrefixer(uri.isAbsolute() ? uri : this.gdcUri.resolve(uriString));
            this.sardine.enablePreemptiveAuthentication(this.prefixer.getUriPrefix().getHost());
        }
        return this.prefixer;
    }

    public URI getUri(String path) {
        return this.getPrefixer().mergeUris(path);
    }

    public void upload(String path, InputStream stream) {
        com.gooddata.util.Validate.notEmpty(path, "path");
        com.gooddata.util.Validate.notNull(stream, "stream");
        this.upload(this.getUri(path), stream);
    }

    private void upload(URI url, InputStream stream) {
        try {
            this.sardine.put(url.toString(), stream);
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to upload to " + url, e);
        }
    }

    public InputStream download(String path) {
        com.gooddata.util.Validate.notEmpty(path, "path");
        URI uri = this.getUri(path);
        try {
            return this.sardine.get(uri.toString());
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to download from " + uri, e);
        }
    }

    public void delete(String path) {
        com.gooddata.util.Validate.notEmpty(path, "path");
        URI uri = this.getUri(path);
        try {
            this.sardine.delete(uri.toString());
        }
        catch (IOException e) {
            throw new DataStoreException("Unable to delete " + uri, e);
        }
    }

    private static class FakeCloseableHttpResponse
    implements CloseableHttpResponse {
        private final HttpResponse wrappedResponse;

        public FakeCloseableHttpResponse(HttpResponse wrappedResponse) {
            Validate.notNull((Object)wrappedResponse, (String)"wrappedResponse cannot be null!");
            this.wrappedResponse = wrappedResponse;
        }

        public void close() throws IOException {
        }

        public StatusLine getStatusLine() {
            return this.wrappedResponse.getStatusLine();
        }

        public void setStatusLine(StatusLine statusline) {
            this.wrappedResponse.setStatusLine(statusline);
        }

        public void setStatusLine(ProtocolVersion ver, int code) {
            this.wrappedResponse.setStatusLine(ver, code);
        }

        public void setStatusLine(ProtocolVersion ver, int code, String reason) {
            this.wrappedResponse.setStatusLine(ver, code, reason);
        }

        public void setStatusCode(int code) throws IllegalStateException {
            this.wrappedResponse.setStatusCode(code);
        }

        public void setReasonPhrase(String reason) throws IllegalStateException {
            this.wrappedResponse.setReasonPhrase(reason);
        }

        public HttpEntity getEntity() {
            return this.wrappedResponse.getEntity();
        }

        public void setEntity(HttpEntity entity) {
            this.wrappedResponse.setEntity(entity);
        }

        public Locale getLocale() {
            return this.wrappedResponse.getLocale();
        }

        public void setLocale(Locale loc) {
            this.wrappedResponse.setLocale(loc);
        }

        public ProtocolVersion getProtocolVersion() {
            return this.wrappedResponse.getProtocolVersion();
        }

        public boolean containsHeader(String name) {
            return this.wrappedResponse.containsHeader(name);
        }

        public Header[] getHeaders(String name) {
            return this.wrappedResponse.getHeaders(name);
        }

        public Header getFirstHeader(String name) {
            return this.wrappedResponse.getFirstHeader(name);
        }

        public Header getLastHeader(String name) {
            return this.wrappedResponse.getLastHeader(name);
        }

        public Header[] getAllHeaders() {
            return this.wrappedResponse.getAllHeaders();
        }

        public void addHeader(Header header) {
            this.wrappedResponse.addHeader(header);
        }

        public void addHeader(String name, String value) {
            this.wrappedResponse.addHeader(name, value);
        }

        public void setHeader(Header header) {
            this.wrappedResponse.setHeader(header);
        }

        public void setHeader(String name, String value) {
            this.wrappedResponse.setHeader(name, value);
        }

        public void setHeaders(Header[] headers) {
            this.wrappedResponse.setHeaders(headers);
        }

        public void removeHeader(Header header) {
            this.wrappedResponse.removeHeader(header);
        }

        public void removeHeaders(String name) {
            this.wrappedResponse.removeHeaders(name);
        }

        public HeaderIterator headerIterator() {
            return this.wrappedResponse.headerIterator();
        }

        public HeaderIterator headerIterator(String name) {
            return this.wrappedResponse.headerIterator(name);
        }

        public HttpParams getParams() {
            return this.wrappedResponse.getParams();
        }

        public void setParams(HttpParams params) {
            this.wrappedResponse.setParams(params);
        }
    }

    private static class FakeCloseableHttpClient
    extends CloseableHttpClient {
        private final HttpClient client;

        private FakeCloseableHttpClient(HttpClient client) {
            com.gooddata.util.Validate.notNull(client, "client can't be null");
            this.client = client;
        }

        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return null;
        }

        public void close() throws IOException {
        }

        @Deprecated
        public HttpParams getParams() {
            return this.client.getParams();
        }

        @Deprecated
        public ClientConnectionManager getConnectionManager() {
            return this.client.getConnectionManager();
        }

        public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(request));
        }

        public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(request, context));
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(target, request));
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return new FakeCloseableHttpResponse(this.client.execute(target, request, context));
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return (T)this.client.execute(request, responseHandler);
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return (T)this.client.execute(request, responseHandler, context);
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return (T)this.client.execute(target, request, responseHandler);
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return (T)this.client.execute(target, request, responseHandler, context);
        }
    }

    private static class CustomHttpClientBuilder
    extends HttpClientBuilder {
        private final HttpClient client;

        private CustomHttpClientBuilder(HttpClient client) {
            this.client = client;
        }

        public CloseableHttpClient build() {
            return new FakeCloseableHttpClient(this.client);
        }
    }
}

