/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataload.processes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.dataload.processes.DataloadProcess;
import com.gooddata.util.Validate;
import java.util.HashMap;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="execution")
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProcessExecution {
    private final String executionsUri;
    private final String executable;
    private final Map<String, String> params;
    private final Map<String, String> hiddenParams;

    public ProcessExecution(DataloadProcess process, String executable) {
        this(process, executable, new HashMap<String, String>(), new HashMap<String, String>());
    }

    public ProcessExecution(DataloadProcess process, String executable, Map<String, String> params) {
        this(process, executable, params, new HashMap<String, String>());
    }

    public ProcessExecution(DataloadProcess process, String executable, Map<String, String> params, Map<String, String> hiddenParams) {
        Validate.notNull(process, "process");
        this.executionsUri = Validate.notEmpty(process.getExecutionsUri(), "process executions link");
        this.executable = executable;
        this.params = Validate.notNull(params, "params");
        this.hiddenParams = Validate.notNull(hiddenParams, "hiddenParams");
        process.validateExecutable(executable);
    }

    public String getExecutable() {
        return this.executable;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHiddenParams() {
        return this.hiddenParams;
    }

    @JsonIgnore
    String getExecutionsUri() {
        return this.executionsUri;
    }
}

