/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.collections;

import com.gooddata.collections.Page;
import com.gooddata.collections.PageRequest;
import com.gooddata.collections.PageableList;
import com.gooddata.collections.Paging;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;

public class MultiPageList<T>
extends PageableList<T> {
    private final PageableList<T> delegate;
    private final Function<Page, PageableList<T>> pageProvider;

    public MultiPageList(Function<Page, PageableList<T>> pageProvider) {
        this(new PageRequest(), pageProvider);
    }

    public MultiPageList(Page startPage, Function<Page, PageableList<T>> pageProvider) {
        this((PageableList)((Function)Validate.notNull(pageProvider, (String)"pageProvider can't be null", (Object[])new Object[0])).apply(startPage), pageProvider);
    }

    MultiPageList(PageableList<T> delegate, Function<Page, PageableList<T>> pageProvider) {
        this.delegate = (PageableList)Validate.notNull(delegate, (String)"delegate can't be null", (Object[])new Object[0]);
        this.pageProvider = (Function)Validate.notNull(pageProvider, (String)"pageProvider can't be null", (Object[])new Object[0]);
    }

    @Override
    public Iterator<T> iterator() {
        return new PageIterator<T>(this.delegate, this.pageProvider);
    }

    @Override
    public List<T> collectAll() {
        return this.stream().collect(Collectors.toList());
    }

    @Override
    public Page getNextPage() {
        return this.delegate.getNextPage();
    }

    @Override
    public boolean hasNextPage() {
        return this.delegate.hasNextPage();
    }

    @Override
    public Map<String, String> getLinks() {
        return this.delegate.getLinks();
    }

    @Override
    public Paging getPaging() {
        return this.delegate.getPaging();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public int totalSize() {
        return (int)this.stream().count();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean add(T item) {
        return this.delegate.add(item);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        return this.delegate.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public T get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.delegate.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    private static final class PageIterator<T>
    implements Iterator<T> {
        private PageableList<T> currentPage;
        private Iterator<T> pageItemsIterator;
        private final Function<Page, PageableList<T>> pageProvider;

        PageIterator(PageableList<T> currentPage, Function<Page, PageableList<T>> pageProvider) {
            this.pageProvider = pageProvider;
            this.currentPage = currentPage;
            this.pageItemsIterator = currentPage.getItemsIterator();
        }

        @Override
        public boolean hasNext() {
            if (this.pageItemsIterator.hasNext()) {
                return true;
            }
            if (this.currentPage.getNextPage() == null) {
                return false;
            }
            PageableList<T> next = this.pageProvider.apply(this.currentPage.getNextPage());
            if (this.currentPage.getNextPage().equals(next.getNextPage())) {
                throw new IllegalStateException("page provider does not iterate properly, returns the same page");
            }
            if (next.isEmpty() && next.getNextPage() != null) {
                throw new IllegalStateException("page has no results, yet claims there is next page");
            }
            this.currentPage = next;
            this.pageItemsIterator = this.currentPage.getItemsIterator();
            return this.pageItemsIterator.hasNext();
        }

        @Override
        public T next() {
            if (!this.pageItemsIterator.hasNext()) {
                throw new NoSuchElementException("no more items left");
            }
            return this.pageItemsIterator.next();
        }
    }
}

