/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.collections;

import com.gooddata.collections.Page;
import com.gooddata.collections.Paging;
import com.gooddata.util.Validate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class PageableList<E>
implements List<E> {
    static final String ITEMS_NODE = "items";
    static final String LINKS_NODE = "links";
    static final String PAGING_NODE = "paging";
    private final List<E> items;
    private final Paging paging;
    private final Map<String, String> links;

    public PageableList() {
        this(Collections.emptyList(), null);
    }

    public PageableList(List<E> items, Paging paging) {
        this(items, paging, null);
    }

    public PageableList(List<E> items, Paging paging, Map<String, String> links) {
        this.items = Validate.notNull(items, ITEMS_NODE);
        this.paging = paging;
        this.links = links;
    }

    public List<E> collectAll() {
        return this.items;
    }

    public Page getNextPage() {
        return this.paging == null ? null : this.paging.getNext();
    }

    public boolean hasNextPage() {
        return this.getNextPage() != null;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    public Paging getPaging() {
        return this.paging;
    }

    @Override
    public int size() {
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.items.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.items.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.items.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.items.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.items.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.items.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.items.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.items.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.items.retainAll(c);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public E get(int index) {
        return this.items.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.items.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.items.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.items.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.items.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.items.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.items.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.items.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.items.subList(fromIndex, toIndex);
    }

    Iterator<E> getItemsIterator() {
        return this.items.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageableList that = (PageableList)o;
        if (!this.items.equals(that.items)) {
            return false;
        }
        if (this.getPaging() != null ? !this.getPaging().equals(that.getPaging()) : that.getPaging() != null) {
            return false;
        }
        return this.getLinks() != null ? this.getLinks().equals(that.getLinks()) : that.getLinks() == null;
    }

    @Override
    public int hashCode() {
        int result = this.items.hashCode();
        result = 31 * result + (this.getPaging() != null ? this.getPaging().hashCode() : 0);
        result = 31 * result + (this.getLinks() != null ? this.getLinks().hashCode() : 0);
        return result;
    }
}

