/*
 * Copyright (C) 2007-2017, GoodData(R) Corporation. All rights reserved.
 * This source code is licensed under the BSD-style license found in the
 * LICENSE.txt file in the root directory of this source tree.
 */
package com.gooddata.executeafm.response;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;

import java.util.List;

/**
 * Header of a measure group.
 */
@JsonRootName(MeasureGroupHeader.NAME)
public class MeasureGroupHeader extends Header {

    static final String NAME = "measureGroupHeader";

    private final List<MeasureHeaderItem> items;

    /**
     * Creates new header
     * @param items header items
     */
    public MeasureGroupHeader(final List<MeasureHeaderItem> items) {
        this.items = items;
    }

    /**
     * Creates new header
     * @param items header items
     * @param totalHeaderItems total header items
     */
    @JsonCreator
    public MeasureGroupHeader(@JsonProperty("items") final List<MeasureHeaderItem> items,
                              @JsonProperty("totalItems") final List<TotalHeaderItem> totalHeaderItems) {
        super(totalHeaderItems);
        this.items = items;
    }

    /**
     * Header items for particular measures
     * @return header items
     */
    public List<MeasureHeaderItem> getItems() {
        return items;
    }
}
