/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataset;

import com.gooddata.AbstractPollHandler;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.PollResult;
import com.gooddata.dataset.Dataset;
import com.gooddata.dataset.DatasetException;
import com.gooddata.dataset.DatasetLinks;
import com.gooddata.dataset.DatasetManifest;
import com.gooddata.dataset.DatasetManifests;
import com.gooddata.dataset.DatasetNotFoundException;
import com.gooddata.dataset.EtlMode;
import com.gooddata.dataset.EtlModeType;
import com.gooddata.dataset.LookupMode;
import com.gooddata.dataset.MaqlDml;
import com.gooddata.dataset.Pull;
import com.gooddata.dataset.PullTask;
import com.gooddata.dataset.TaskState;
import com.gooddata.dataset.Upload;
import com.gooddata.dataset.UploadStatistics;
import com.gooddata.dataset.Uploads;
import com.gooddata.dataset.UploadsInfo;
import com.gooddata.gdc.AboutLinks;
import com.gooddata.gdc.DataStoreException;
import com.gooddata.gdc.DataStoreService;
import com.gooddata.gdc.TaskStatus;
import com.gooddata.gdc.UriResponse;
import com.gooddata.project.Project;
import com.gooddata.util.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class DatasetService
extends AbstractService {
    private static final String MANIFEST_FILE_NAME = "upload_info.json";
    private static final String ETL_PULL_DEFAULT_ERROR_MESSAGE = "ETL Pull failed with status %s";
    private final DataStoreService dataStoreService;

    public DatasetService(RestTemplate restTemplate, DataStoreService dataStoreService, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.dataStoreService = (DataStoreService)Validate.notNull((Object)dataStoreService, (String)"dataStoreService");
    }

    @Deprecated
    public DatasetService(RestTemplate restTemplate, DataStoreService dataStoreService) {
        super(restTemplate);
        this.dataStoreService = (DataStoreService)Validate.notNull((Object)dataStoreService, (String)"dataStoreService");
    }

    public DatasetManifest getDatasetManifest(Project project, String datasetId) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notEmpty((CharSequence)datasetId, (String)"datasetId");
        try {
            return (DatasetManifest)this.restTemplate.getForObject("/gdc/md/{projectId}/ldm/singleloadinterface/{dataSet}/manifest", DatasetManifest.class, new Object[]{project.getId(), datasetId});
        }
        catch (GoodDataRestException e) {
            if (e.getStatusCode() == 404) {
                throw new DatasetNotFoundException(datasetId, e);
            }
            throw new DatasetException("Unable to get manifest", datasetId, (Throwable)e);
        }
        catch (RestClientException e) {
            throw new DatasetException("Unable to get manifest", datasetId, (Throwable)e);
        }
    }

    public FutureResult<Void> loadDataset(Project project, DatasetManifest manifest, InputStream dataset) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)dataset, (String)"dataset");
        Validate.notNull((Object)manifest, (String)"manifest");
        manifest.setSource(dataset);
        return this.loadDatasets(project, manifest);
    }

    public FutureResult<Void> loadDataset(Project project, String datasetId, InputStream dataset) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notEmpty((CharSequence)datasetId, (String)"datasetId");
        Validate.notNull((Object)dataset, (String)"dataset");
        return this.loadDataset(project, this.getDatasetManifest(project, datasetId), dataset);
    }

    public FutureResult<Void> loadDatasets(Project project, DatasetManifest ... datasets) {
        return this.loadDatasets(project, Arrays.asList(datasets));
    }

    public FutureResult<Void> loadDatasets(Project project, Collection<DatasetManifest> datasets) {
        Validate.notNull((Object)project, (String)"project");
        this.validateUploadManifests(datasets);
        ArrayList<String> datasetsNames = new ArrayList<String>(datasets.size());
        try {
            String dirPath = "/" + project.getId() + "_" + RandomStringUtils.randomAlphabetic((int)3) + "/";
            for (DatasetManifest datasetManifest : datasets) {
                datasetsNames.add(datasetManifest.getDataSet());
                this.dataStoreService.upload(dirPath + datasetManifest.getFile(), datasetManifest.getSource());
            }
            String manifestJson = this.mapper.writeValueAsString((Object)new DatasetManifests(datasets));
            ByteArrayInputStream inputStream = new ByteArrayInputStream(manifestJson.getBytes(StandardCharsets.UTF_8));
            this.dataStoreService.upload(dirPath + MANIFEST_FILE_NAME, (InputStream)inputStream);
            return this.pullLoad(project, dirPath, datasetsNames);
        }
        catch (IOException e) {
            throw new DatasetException("Unable to serialize manifest", datasetsNames, (Throwable)e);
        }
        catch (GoodDataRestException | DataStoreException | RestClientException e) {
            throw new DatasetException("Unable to load", datasetsNames, (Throwable)e);
        }
    }

    private void validateUploadManifests(Collection<DatasetManifest> datasets) {
        Validate.notEmpty(datasets, (String)"datasets");
        for (DatasetManifest datasetManifest : datasets) {
            if (datasetManifest.getSource() == null) {
                throw new IllegalArgumentException(String.format("Source for dataset '%s' is null", datasetManifest.getDataSet()));
            }
            if (datasetManifest.getFile() == null) {
                throw new IllegalArgumentException(String.format("File for dataset '%s' is null", datasetManifest.getDataSet()));
            }
            if (!StringUtils.isEmpty((Object)datasetManifest.getDataSet())) continue;
            throw new IllegalArgumentException("Dataset name is empty.");
        }
    }

    private FutureResult<Void> pullLoad(Project project, final String dirPath, final Collection<String> datasets) {
        Validate.notNull((Object)project.getId(), (String)"project.id");
        PullTask pullTask = (PullTask)this.restTemplate.postForObject("/gdc/md/{projectId}/etl/pull2", (Object)new Pull(dirPath), PullTask.class, new Object[]{project.getId()});
        return new PollResult<Void>(this, new AbstractPollHandler<TaskStatus, Void>(pullTask.getPollUri(), TaskStatus.class, Void.class){

            @Override
            public void handlePollResult(TaskStatus pollResult) {
                if (!pollResult.isSuccess()) {
                    String message = StringUtils.isEmpty(pollResult.getMessages()) ? String.format(DatasetService.ETL_PULL_DEFAULT_ERROR_MESSAGE, pollResult.getStatus()) : pollResult.getMessages().toString();
                    throw new DatasetException(message, datasets);
                }
                this.setResult(null);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new DatasetException("Unable to load", datasets, (Throwable)e);
            }

            @Override
            protected void onFinish() {
                try {
                    DatasetService.this.dataStoreService.delete(dirPath);
                }
                catch (DataStoreException dataStoreException) {
                    // empty catch block
                }
            }
        });
    }

    @Deprecated
    public Collection<Dataset> listDatasets(Project project) {
        return this.listDatasetLinks(project).stream().map(link -> new Dataset(link.getIdentifier(), link.getUri(), link.getTitle())).collect(Collectors.toCollection(HashSet::new));
    }

    public Collection<AboutLinks.Link> listDatasetLinks(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        try {
            DatasetLinks result = (DatasetLinks)this.restTemplate.getForObject("/gdc/md/{project}/ldm/singleloadinterface", DatasetLinks.class, new Object[]{project.getId()});
            if (result == null) {
                throw new GoodDataException("Empty response from API call");
            }
            if (result.getLinks() == null) {
                return Collections.emptyList();
            }
            return result.getLinks();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list datasets for project " + project.getId(), e);
        }
    }

    public FutureResult<Void> optimizeSliHash(final Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        UriResponse uriResponse = (UriResponse)this.restTemplate.postForObject("/gdc/md/{project}/etl/mode", (Object)new EtlMode(EtlModeType.SLI, LookupMode.RECREATE), UriResponse.class, new Object[]{project.getId()});
        return new PollResult<Void>(this, new AbstractPollHandler<TaskStatus, Void>(uriResponse.getUri(), TaskStatus.class, Void.class){

            @Override
            public void handlePollResult(TaskStatus pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new GoodDataException("Unable to optimize SLI hash for project " + project.getId());
                }
                this.setResult(null);
            }

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                if (!super.isFinished(response)) {
                    return false;
                }
                TaskStatus maqlDdlTaskStatus = (TaskStatus)DatasetService.this.extractData(response, TaskStatus.class);
                if (maqlDdlTaskStatus.isSuccess()) {
                    return true;
                }
                throw new GoodDataException("Unable to optimize SLI hash: " + maqlDdlTaskStatus.getMessages());
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException("Unable to optimize SLI hash: " + this.getPollingUri(), (Throwable)e);
            }
        });
    }

    public FutureResult<Void> updateProjectData(Project project, String maqlDml) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        UriResponse uriResponse = (UriResponse)this.restTemplate.postForObject("/gdc/md/{project}/dml/manage", (Object)new MaqlDml(maqlDml), UriResponse.class, new Object[]{project.getId()});
        final String errorMessage = String.format("Unable to update data for project '%s'", project.getId());
        return new PollResult<Void>(this, new AbstractPollHandler<TaskState, Void>(uriResponse.getUri(), TaskState.class, Void.class){

            @Override
            public void handlePollResult(TaskState pollResult) {
                if (!pollResult.isSuccess()) {
                    throw new GoodDataException(errorMessage);
                }
                this.setResult(null);
            }

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                TaskState taskState = (TaskState)DatasetService.this.extractData(response, TaskState.class);
                if (taskState.isSuccess()) {
                    return true;
                }
                if (!taskState.isFinished()) {
                    return false;
                }
                throw new GoodDataException(errorMessage + ": " + taskState.getMessage());
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new GoodDataException(errorMessage + ": " + this.getPollingUri(), (Throwable)e);
            }
        });
    }

    public Collection<Upload> listUploadsForDataset(Project project, String datasetId) {
        UploadsInfo.DataSet dataSet = this.getDataSetInfo(project, datasetId);
        if (StringUtils.isEmpty((Object)dataSet.getUploadsUri())) {
            return Collections.emptyList();
        }
        try {
            Uploads result = (Uploads)this.restTemplate.getForObject(dataSet.getUploadsUri(), Uploads.class, new Object[0]);
            if (result == null) {
                throw new GoodDataException("Empty response from '" + dataSet.getUploadsUri() + "'.");
            }
            if (result.items() == null) {
                return Collections.emptyList();
            }
            return result.items();
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get '" + dataSet.getUploadsUri() + "'.", (Throwable)e);
        }
    }

    public Upload getLastUploadForDataset(Project project, String datasetId) {
        UploadsInfo.DataSet dataSet = this.getDataSetInfo(project, datasetId);
        if (StringUtils.isEmpty((Object)dataSet.getLastUploadUri())) {
            return null;
        }
        try {
            return (Upload)this.restTemplate.getForObject(dataSet.getLastUploadUri(), Upload.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get '" + dataSet.getLastUploadUri() + "'.");
        }
    }

    public UploadStatistics getUploadStatistics(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        try {
            return (UploadStatistics)this.restTemplate.getForObject("/gdc/md/{projectId}/data/uploads_info", UploadStatistics.class, new Object[]{project.getId()});
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get dataset uploads statistics.", (Throwable)e);
        }
    }

    UploadsInfo.DataSet getDataSetInfo(Project project, String datasetId) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        Validate.notEmpty((CharSequence)datasetId, (String)"datasetId");
        URI uploadsInfoUri = UploadsInfo.URI_TEMPLATE.expand(new Object[]{project.getId()});
        try {
            UploadsInfo uploadsInfo = (UploadsInfo)this.restTemplate.getForObject(uploadsInfoUri, UploadsInfo.class);
            if (uploadsInfo == null) {
                throw new GoodDataException("Empty response from '" + uploadsInfoUri.toString() + "'.");
            }
            return uploadsInfo.getDataSet(datasetId);
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get '" + uploadsInfoUri.toString() + "'.", (Throwable)e);
        }
    }
}

