/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.executeafm.afm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.gooddata.executeafm.ObjQualifier;
import com.gooddata.executeafm.UriObjQualifier;
import com.gooddata.executeafm.afm.Aggregation;
import com.gooddata.executeafm.afm.FilterItem;
import com.gooddata.executeafm.afm.MeasureDefinition;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonRootName(value="measure")
public class SimpleMeasureDefinition
implements MeasureDefinition,
Serializable {
    private static final long serialVersionUID = -385490772711914776L;
    static final String NAME = "measure";
    private final ObjQualifier item;
    private String aggregation;
    private Boolean computeRatio;
    private List<FilterItem> filters;

    public SimpleMeasureDefinition(ObjQualifier item) {
        this.item = item;
    }

    @JsonCreator
    public SimpleMeasureDefinition(@JsonProperty(value="item") ObjQualifier item, @JsonProperty(value="aggregation") String aggregation, @JsonProperty(value="computeRatio") Boolean computeRatio, @JsonProperty(value="filters") List<FilterItem> filters) {
        this.item = item;
        this.aggregation = aggregation;
        this.computeRatio = computeRatio;
        this.filters = filters;
    }

    public SimpleMeasureDefinition(ObjQualifier item, Aggregation aggregation, Boolean computeRatio, List<FilterItem> filters) {
        this(item, ((Aggregation)((Object)Validate.notNull((Object)((Object)aggregation), (String)"aggregation"))).toString(), computeRatio, filters);
    }

    public SimpleMeasureDefinition(ObjQualifier item, Aggregation aggregation, Boolean computeRatio, FilterItem ... filters) {
        this(item, aggregation, computeRatio, Arrays.asList(filters));
    }

    @Override
    public MeasureDefinition withObjUriQualifier(UriObjQualifier qualifier) {
        return new SimpleMeasureDefinition((ObjQualifier)qualifier, this.aggregation, this.computeRatio, this.filters);
    }

    @Override
    public boolean isAdHoc() {
        return this.hasAggregation() || this.hasComputeRatio() || this.hasFilters();
    }

    @Override
    public String getUri() {
        return this.getItem().getUri();
    }

    @Override
    public ObjQualifier getObjQualifier() {
        return this.getItem();
    }

    public ObjQualifier getItem() {
        return this.item;
    }

    public String getAggregation() {
        return this.aggregation;
    }

    public void setAggregation(String aggregation) {
        this.aggregation = aggregation;
    }

    public void setAggregation(Aggregation aggregation) {
        this.setAggregation(((Aggregation)((Object)Validate.notNull((Object)((Object)aggregation), (String)"aggregation"))).toString());
    }

    public Boolean getComputeRatio() {
        return this.computeRatio;
    }

    public void setComputeRatio(Boolean computeRatio) {
        this.computeRatio = computeRatio;
    }

    public List<FilterItem> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterItem> filters) {
        this.filters = filters;
    }

    public void addFilter(FilterItem filter) {
        if (this.filters == null) {
            this.filters = new ArrayList<FilterItem>();
        }
        this.filters.add((FilterItem)Validate.notNull((Object)filter, (String)"filter"));
    }

    public boolean hasFilters() {
        return this.filters != null && !this.filters.isEmpty();
    }

    public boolean hasComputeRatio() {
        return this.computeRatio != null && this.computeRatio != false;
    }

    public boolean hasAggregation() {
        return this.aggregation != null;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }
}

