/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.export;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.gooddata.AbstractService;
import com.gooddata.FutureResult;
import com.gooddata.GoodDataEndpoint;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.PollResult;
import com.gooddata.SimplePollHandler;
import com.gooddata.export.ClientExport;
import com.gooddata.export.ExecuteReport;
import com.gooddata.export.ExecuteReportDefinition;
import com.gooddata.export.ExportException;
import com.gooddata.export.ExportFormat;
import com.gooddata.export.NoDataExportException;
import com.gooddata.export.ReportRequest;
import com.gooddata.gdc.AsyncTask;
import com.gooddata.gdc.UriResponse;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Obj;
import com.gooddata.md.ProjectDashboard;
import com.gooddata.md.report.Report;
import com.gooddata.md.report.ReportDefinition;
import com.gooddata.project.Project;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class ExportService
extends AbstractService {
    public static final String EXPORTING_URI = "/gdc/exporter/executor";
    private static final String CLIENT_EXPORT_URI = "/gdc/projects/{projectId}/clientexport";
    private static final String RAW_EXPORT_URI = "/gdc/projects/{projectId}/execute/raw";
    private final GoodDataEndpoint endpoint;

    public ExportService(RestTemplate restTemplate, GoodDataEndpoint endpoint, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.endpoint = (GoodDataEndpoint)Validate.notNull((Object)endpoint, (String)"endpoint");
    }

    @Deprecated
    public ExportService(RestTemplate restTemplate, GoodDataEndpoint endpoint) {
        super(restTemplate);
        this.endpoint = (GoodDataEndpoint)Validate.notNull((Object)endpoint, (String)"endpoint");
    }

    public FutureResult<Void> export(ReportDefinition reportDefinition, ExportFormat format, OutputStream output) {
        Validate.notNull((Object)reportDefinition, (String)"reportDefinition");
        ExecuteReportDefinition request = new ExecuteReportDefinition(reportDefinition);
        return this.exportReport(request, format, output);
    }

    public FutureResult<Void> export(Report report, ExportFormat format, OutputStream output) {
        Validate.notNull((Object)report, (String)"report");
        ExecuteReport request = new ExecuteReport(report);
        return this.exportReport(request, format, output);
    }

    private FutureResult<Void> exportReport(ReportRequest request, ExportFormat format, final OutputStream output) {
        Validate.notNull((Object)output, (String)"output");
        Validate.notNull((Object)((Object)format), (String)"format");
        JsonNode execResult = this.executeReport("/gdc/xtab2/executor3", request);
        final String uri = this.exportReport(execResult, format);
        return new PollResult<Void>(this, new SimplePollHandler<Void>(uri, Void.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                switch (response.getStatusCode()) {
                    case OK: {
                        return true;
                    }
                    case ACCEPTED: {
                        return false;
                    }
                    case NO_CONTENT: {
                        throw new NoDataExportException();
                    }
                }
                throw new ExportException("Unable to export report, unknown HTTP response code: " + response.getStatusCode());
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ExportException("Unable to export report", e);
            }

            @Override
            protected void onFinish() {
                try {
                    ExportService.this.restTemplate.execute(uri, HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(output), new Object[0]);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new ExportException("Unable to export report", e);
                }
            }
        });
    }

    protected JsonNode executeReport(String executionUri, ReportRequest request) {
        try {
            ResponseEntity entity = this.restTemplate.exchange(executionUri, HttpMethod.POST, new HttpEntity((Object)request), String.class, new Object[0]);
            return this.mapper.readTree((String)entity.getBody());
        }
        catch (GoodDataException | RestClientException e) {
            throw new ExportException("Unable to execute report", e);
        }
        catch (IOException e) {
            throw new ExportException("Unable to read execution result", e);
        }
    }

    private String exportReport(JsonNode execResult, ExportFormat format) {
        Validate.notNull((Object)execResult, (String)"execResult");
        Validate.notNull((Object)((Object)format), (String)"format");
        ObjectNode root = this.mapper.createObjectNode();
        ObjectNode child = this.mapper.createObjectNode();
        child.set("result", execResult);
        child.put("format", format.getValue());
        root.set("result_req", (JsonNode)child);
        try {
            return ((UriResponse)this.restTemplate.postForObject(EXPORTING_URI, (Object)root, UriResponse.class, new Object[0])).getUri();
        }
        catch (GoodDataException | RestClientException e) {
            throw new ExportException("Unable to export report", e);
        }
    }

    public FutureResult<Void> exportPdf(ProjectDashboard dashboard, ProjectDashboard.Tab tab, final OutputStream output) {
        AsyncTask task;
        Validate.notNull((Object)dashboard, (String)"dashboard");
        Validate.notNull((Object)tab, (String)"tab");
        Validate.notNull((Object)output, (String)"output");
        String projectId = ExportService.extractProjectId(dashboard);
        String projectUri = Project.TEMPLATE.expand(new Object[]{projectId}).toString();
        final String dashboardUri = dashboard.getUri();
        ClientExport export = new ClientExport(this.endpoint, projectUri, dashboardUri, tab.getIdentifier());
        try {
            task = (AsyncTask)this.restTemplate.postForObject(CLIENT_EXPORT_URI, (Object)export, AsyncTask.class, new Object[]{projectId});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ExportException("Unable to export dashboard: " + dashboardUri, e);
        }
        return new PollResult<Void>(this, new SimplePollHandler<Void>(task.getUri(), Void.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                switch (response.getStatusCode()) {
                    case OK: {
                        return true;
                    }
                    case ACCEPTED: {
                        return false;
                    }
                }
                throw new ExportException("Unable to export dashboard: " + dashboardUri + ", unknown HTTP response code: " + response.getStatusCode());
            }

            @Override
            protected void onFinish() {
                try {
                    ExportService.this.restTemplate.execute(task.getUri(), HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(output), new Object[0]);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new ExportException("Unable to export dashboard: " + dashboardUri, e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ExportException("Unable to export dashboard: " + dashboardUri, e);
            }
        });
    }

    public FutureResult<Void> exportCsv(Report report, OutputStream output) {
        Validate.notNull((Object)report, (String)"report");
        return this.exportCsv(report, new ExecuteReport(report), output);
    }

    public FutureResult<Void> exportCsv(ReportDefinition definition, OutputStream output) {
        ExecuteReportDefinition request = new ExecuteReportDefinition(definition);
        return this.exportCsv(definition, request, output);
    }

    private FutureResult<Void> exportCsv(AbstractObj obj, ReportRequest request, final OutputStream output) {
        UriResponse response;
        Validate.notNull((Object)obj, (String)"obj");
        Validate.notNull((Object)request, (String)"request");
        Validate.notNull((Object)output, (String)"output");
        String projectId = ExportService.extractProjectId(obj);
        final String uri = obj.getUri();
        try {
            response = (UriResponse)this.restTemplate.postForObject(RAW_EXPORT_URI, (Object)request, UriResponse.class, new Object[]{projectId});
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new ExportException("Unable to export: " + uri);
        }
        if (response == null || response.getUri() == null) {
            throw new ExportException("Empty response, unable to export: " + uri);
        }
        return new PollResult<Void>(this, new SimplePollHandler<Void>(response.getUri(), Void.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                switch (response.getStatusCode()) {
                    case OK: {
                        return true;
                    }
                    case ACCEPTED: {
                        return false;
                    }
                    case NO_CONTENT: {
                        throw new NoDataExportException();
                    }
                }
                throw new ExportException("Unable to export: " + uri + ", unknown HTTP response code: " + response.getStatusCode());
            }

            @Override
            protected void onFinish() {
                try {
                    ExportService.this.restTemplate.execute(this.getPolling(), HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(output));
                }
                catch (GoodDataException | RestClientException e) {
                    throw new ExportException("Unable to export: " + uri, e);
                }
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ExportException("Unable to export: " + uri, e);
            }
        });
    }

    static String extractProjectId(AbstractObj obj) {
        Validate.notNull((Object)obj, (String)"obj");
        Validate.notNull((Object)obj.getUri(), (String)"obj.uri");
        String projectId = (String)Obj.OBJ_TEMPLATE.match(obj.getUri()).get("projectId");
        Validate.notNull((Object)projectId, (String)"obj uri - project id");
        return projectId;
    }
}

