/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.gooddata.util.Validate;
import java.io.IOException;

public class BooleanDeserializer
extends JsonDeserializer<Boolean> {
    private static final Integer ONE = 1;

    public Boolean deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode root = (JsonNode)jp.readValueAsTree();
        Validate.notNull(root, "jsonNode");
        if (root.isInt()) {
            return ONE.equals(root.numberValue());
        }
        if (root.isTextual()) {
            return "1".equals(root.textValue());
        }
        throw JsonMappingException.from((JsonParser)jp, (String)("Unknown value of type: " + root.getNodeType()));
    }
}

