/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.sdk.service.GoodDataRestProvider;
import com.gooddata.sdk.service.GoodDataServices;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.account.AccountService;
import com.gooddata.sdk.service.auditevent.AuditEventService;
import com.gooddata.sdk.service.connector.ConnectorService;
import com.gooddata.sdk.service.dataload.OutputStageService;
import com.gooddata.sdk.service.dataload.processes.ProcessService;
import com.gooddata.sdk.service.dataset.DatasetService;
import com.gooddata.sdk.service.executeafm.ExecuteAfmService;
import com.gooddata.sdk.service.export.ExportService;
import com.gooddata.sdk.service.featureflag.FeatureFlagService;
import com.gooddata.sdk.service.gdc.DataStoreService;
import com.gooddata.sdk.service.gdc.GdcService;
import com.gooddata.sdk.service.httpcomponents.LoginPasswordGoodDataRestProvider;
import com.gooddata.sdk.service.lcm.LcmService;
import com.gooddata.sdk.service.md.MetadataService;
import com.gooddata.sdk.service.md.maintenance.ExportImportService;
import com.gooddata.sdk.service.notification.NotificationService;
import com.gooddata.sdk.service.project.ProjectService;
import com.gooddata.sdk.service.project.model.ModelService;
import com.gooddata.sdk.service.projecttemplate.ProjectTemplateService;
import com.gooddata.sdk.service.warehouse.WarehouseService;
import com.gooddata.util.Validate;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

public class GoodData {
    private final GoodDataServices services;

    public GoodData(String login, String password) {
        this("secure.gooddata.com", login, password, new GoodDataSettings());
    }

    public GoodData(String login, String password, GoodDataSettings settings) {
        this("secure.gooddata.com", login, password, settings);
    }

    public GoodData(String hostname, String login, String password) {
        this(hostname, login, password, 443, "https", new GoodDataSettings());
    }

    public GoodData(String hostname, String login, String password, GoodDataSettings settings) {
        this(hostname, login, password, 443, "https", settings);
    }

    public GoodData(String hostname, String login, String password, int port) {
        this(hostname, login, password, port, "https", new GoodDataSettings());
    }

    public GoodData(String hostname, String login, String password, int port, GoodDataSettings settings) {
        this(hostname, login, password, port, "https", settings);
    }

    protected GoodData(String hostname, String login, String password, int port, String protocol, GoodDataSettings settings) {
        this(new LoginPasswordGoodDataRestProvider(new GoodDataEndpoint(hostname, port, protocol), settings, login, password));
    }

    protected GoodData(GoodDataRestProvider goodDataRestProvider) {
        this.services = new GoodDataServices((GoodDataRestProvider)Validate.notNull((Object)goodDataRestProvider, (String)"goodDataRestProvider"));
    }

    protected RestTemplate getRestTemplate() {
        return this.services.getRestTemplate();
    }

    public void logout() {
        this.getAccountService().logout();
    }

    @Bean(value={"goodDataProjectService"})
    public ProjectService getProjectService() {
        return this.services.getProjectService();
    }

    @Bean(value={"goodDataAccountService"})
    public AccountService getAccountService() {
        return this.services.getAccountService();
    }

    @Bean(value={"goodDataMetadataService"})
    public MetadataService getMetadataService() {
        return this.services.getMetadataService();
    }

    @Bean(value={"goodDataModelService"})
    public ModelService getModelService() {
        return this.services.getModelService();
    }

    @Bean(value={"goodDataGdcService"})
    public GdcService getGdcService() {
        return this.services.getGdcService();
    }

    @Bean(value={"goodDataDataStoreService"})
    public DataStoreService getDataStoreService() {
        return this.services.getDataStoreService();
    }

    @Bean(value={"goodDataDatasetService"})
    public DatasetService getDatasetService() {
        return this.services.getDatasetService();
    }

    @Bean(value={"goodDataExportService"})
    public ExportService getExportService() {
        return this.services.getExportService();
    }

    @Bean(value={"goodDataProcessService"})
    public ProcessService getProcessService() {
        return this.services.getProcessService();
    }

    @Bean(value={"goodDataWarehouseService"})
    public WarehouseService getWarehouseService() {
        return this.services.getWarehouseService();
    }

    @Bean(value={"goodDataConnectorService"})
    public ConnectorService getConnectorService() {
        return this.services.getConnectorService();
    }

    @Bean(value={"goodDataNotificationService"})
    public NotificationService getNotificationService() {
        return this.services.getNotificationService();
    }

    @Bean(value={"goodDataExportImportService"})
    public ExportImportService getExportImportService() {
        return this.services.getExportImportService();
    }

    @Bean(value={"goodDataFeatureFlagService"})
    public FeatureFlagService getFeatureFlagService() {
        return this.services.getFeatureFlagService();
    }

    @Bean(value={"goodDataOutputStageService"})
    public OutputStageService getOutputStageService() {
        return this.services.getOutputStageService();
    }

    @Bean(value={"goodDataProjectTemplateService"})
    public ProjectTemplateService getProjectTemplateService() {
        return this.services.getProjectTemplateService();
    }

    @Bean(value={"goodDataAuditEventService"})
    public AuditEventService getAuditEventService() {
        return this.services.getAuditEventService();
    }

    @Bean(value={"goodDataExecuteAfmService"})
    public ExecuteAfmService getExecuteAfmService() {
        return this.services.getExecuteAfmService();
    }

    @Bean(value={"goodDataLcmService"})
    public LcmService getLcmService() {
        return this.services.getLcmService();
    }
}

