/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.account;

import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.sdk.model.account.Account;
import com.gooddata.sdk.model.account.SeparatorSettings;
import com.gooddata.sdk.model.gdc.UriResponse;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.account.AccountNotFoundException;
import com.gooddata.util.Validate;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class AccountService
extends AbstractService {
    protected static final UriTemplate ACCOUNT_TEMPLATE = new UriTemplate("/gdc/account/profile/{id}");
    protected static final UriTemplate ACCOUNTS_TEMPLATE = new UriTemplate("/gdc/account/domains/{organization_name}/users");
    protected static final UriTemplate LOGIN_TEMPLATE = new UriTemplate("/gdc/account/login/{id}");
    protected static final UriTemplate SEPARATORS_TEMPLATE = new UriTemplate("/gdc/account/profile/{id}/settings/separators");

    public AccountService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public Account getCurrent() {
        return this.getAccountById("current");
    }

    public void logout() {
        try {
            String id = this.getCurrent().getId();
            this.restTemplate.delete("/gdc/account/login/{id}", new Object[]{id});
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to logout", e);
        }
    }

    public Account createAccount(Account account, String organizationName) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notEmpty((CharSequence)organizationName, (String)"organizationName");
        try {
            UriResponse uriResponse = (UriResponse)this.restTemplate.postForObject("/gdc/account/domains/{organization_name}/users", (Object)account, UriResponse.class, new Object[]{organizationName});
            return this.getAccountByUri(uriResponse.getUri());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create account", e);
        }
    }

    public void removeAccount(Account account) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notNull((Object)account.getUri(), (String)"account.uri");
        try {
            this.restTemplate.delete(account.getUri(), new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new AccountNotFoundException(account.getUri(), e);
            }
            throw e;
        }
        catch (GoodDataException e) {
            throw new GoodDataException("Unable to remove account", (Throwable)e);
        }
    }

    public Account getAccountById(String id) {
        Validate.notNull((Object)id, (String)"id");
        try {
            return (Account)this.restTemplate.getForObject("/gdc/account/profile/{id}", Account.class, new Object[]{id});
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new AccountNotFoundException(ACCOUNT_TEMPLATE.expand(new Object[]{id}).toString(), e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get account", (Throwable)e);
        }
    }

    public Account getAccountByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"uri");
        return this.getAccountById(Account.getId((String)uri));
    }

    public void updateAccount(Account account) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notNull((Object)account.getUri(), (String)"account.uri");
        try {
            MappingJacksonValue jacksonValue = new MappingJacksonValue((Object)account);
            jacksonValue.setSerializationView(Account.UpdateView.class);
            this.restTemplate.put(account.getUri(), (Object)jacksonValue, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new AccountNotFoundException(account.getUri(), e);
            }
            throw e;
        }
        catch (GoodDataException e) {
            throw new GoodDataException("Unable to update account", (Throwable)e);
        }
    }

    public SeparatorSettings getSeparatorSettings(Account account) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notEmpty((CharSequence)account.getUri(), (String)"account.uri");
        try {
            return (SeparatorSettings)this.restTemplate.getForObject(SEPARATORS_TEMPLATE.expand(new Object[]{account.getId()}), SeparatorSettings.class);
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get separators for account=" + account.getUri(), (Throwable)e);
        }
    }
}

