/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.common;

import com.gooddata.sdk.common.HttpClient4ComponentsClientHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class HttpClient4ComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient4ComponentsClientHttpRequestFactory.class);
    private final HttpClient httpClient;

    public HttpClient4ComponentsClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
        this.httpClient = httpClient;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        return new HttpClient4ComponentsClientHttpRequest(this.httpClient, httpRequest);
    }

    private HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            return new HttpGet(uri);
        }
        if (HttpMethod.HEAD.equals((Object)httpMethod)) {
            return new HttpHead(uri);
        }
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            return new HttpPost(uri);
        }
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            return new HttpPut(uri);
        }
        if (HttpMethod.PATCH.equals((Object)httpMethod)) {
            return new HttpPatch(uri);
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            return new HttpDelete(uri);
        }
        if (HttpMethod.OPTIONS.equals((Object)httpMethod)) {
            return new HttpOptions(uri);
        }
        if (HttpMethod.TRACE.equals((Object)httpMethod)) {
            return new HttpTrace(uri);
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + String.valueOf(httpMethod));
    }

    private static class HttpClient4ComponentsClientHttpRequest
    implements ClientHttpRequest {
        private final HttpClient httpClient;
        private final HttpUriRequest httpRequest;
        private final HttpHeaders headers;
        private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

        public HttpClient4ComponentsClientHttpRequest(HttpClient httpClient, HttpUriRequest httpRequest) {
            this.httpClient = httpClient;
            this.httpRequest = httpRequest;
            this.headers = new HttpHeaders();
        }

        public HttpMethod getMethod() {
            return HttpMethod.valueOf((String)this.httpRequest.getMethod());
        }

        public String getMethodValue() {
            return this.httpRequest.getMethod();
        }

        public URI getURI() {
            return this.httpRequest.getURI();
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public OutputStream getBody() throws IOException {
            return this.bufferedOutput;
        }

        public ClientHttpResponse execute() throws IOException {
            HttpResponse httpResponse;
            byte[] bytes = this.bufferedOutput.toByteArray();
            if (bytes.length > 0 && this.httpRequest instanceof HttpEntityEnclosingRequest) {
                HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)this.httpRequest;
                ByteArrayEntity requestEntity = new ByteArrayEntity(bytes);
                if (logger.isDebugEnabled()) {
                    boolean hasContentType = false;
                    for (Header header : this.httpRequest.getAllHeaders()) {
                        if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
                        hasContentType = true;
                        break;
                    }
                    if (!hasContentType) {
                        // empty if block
                    }
                }
                entityRequest.setEntity((HttpEntity)requestEntity);
            }
            this.addHeaders((HttpRequest)this.httpRequest);
            if (this.httpClient.getClass().getName().contains("GoodDataHttpClient")) {
                try {
                    Method executeMethod = this.httpClient.getClass().getMethod("execute", HttpUriRequest.class);
                    httpResponse = (HttpResponse)executeMethod.invoke((Object)this.httpClient, this.httpRequest);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method executeMethod = this.httpClient.getClass().getMethod("execute", HttpUriRequest.class, HttpContext.class);
                        httpResponse = (HttpResponse)executeMethod.invoke((Object)this.httpClient, this.httpRequest, null);
                    }
                    catch (Exception e2) {
                        throw new IOException("Failed to execute request with GoodDataHttpClient", e2);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Failed to execute request with GoodDataHttpClient", e);
                }
            } else {
                httpResponse = this.httpClient.execute(this.httpRequest);
            }
            return new HttpClient4ComponentsClientHttpResponse(httpResponse);
        }

        private void addHeaders(HttpRequest httpRequest) {
            if (httpRequest instanceof HttpUriRequest) {
                HttpUriRequest uriRequest = (HttpUriRequest)httpRequest;
                uriRequest.removeHeaders("Accept");
                uriRequest.removeHeaders("X-GDC-Version");
                uriRequest.removeHeaders("Content-Type");
            }
            if (this.headers.containsKey((Object)"Accept")) {
                String acceptValue = String.join((CharSequence)", ", this.headers.get((Object)"Accept"));
                httpRequest.setHeader("Accept", acceptValue);
            }
            if (this.headers.containsKey((Object)"X-GDC-Version")) {
                String versionValue = String.join((CharSequence)", ", this.headers.get((Object)"X-GDC-Version"));
                httpRequest.setHeader("X-GDC-Version", versionValue);
            }
            Object finalContentType = null;
            if (this.headers.containsKey((Object)"Content-Type")) {
                String contentTypeValue = String.join((CharSequence)", ", this.headers.get((Object)"Content-Type"));
                finalContentType = contentTypeValue.contains("application/json") && !contentTypeValue.contains("charset=") ? contentTypeValue + "; charset=UTF-8" : contentTypeValue;
            } else if (httpRequest instanceof HttpEntityEnclosingRequest) {
                finalContentType = "application/json; charset=UTF-8";
            }
            if (finalContentType != null) {
                httpRequest.setHeader("Content-Type", (String)finalContentType);
            }
            this.headers.entrySet().stream().filter(entry -> {
                String headerName = (String)entry.getKey();
                return !"Content-Length".equalsIgnoreCase(headerName) && !"Transfer-Encoding".equalsIgnoreCase(headerName) && !"Content-Type".equalsIgnoreCase(headerName) && !"Accept".equalsIgnoreCase(headerName) && !"X-GDC-Version".equalsIgnoreCase(headerName);
            }).sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                String headerName = (String)entry.getKey();
                List headerValues = (List)entry.getValue();
                String headerValue = "Cookie".equalsIgnoreCase(headerName) ? String.join((CharSequence)"; ", headerValues) : String.join((CharSequence)", ", headerValues);
                httpRequest.setHeader(headerName, headerValue);
            });
        }
    }
}

