/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.common;

import com.gooddata.sdk.common.util.Validate;
import java.io.IOException;
import java.net.URI;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class UriPrefixingClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private final ClientHttpRequestFactory requestFactory;
    private final URI baseUri;

    public UriPrefixingClientHttpRequestFactory(ClientHttpRequestFactory requestFactory, URI baseUri) {
        this.requestFactory = (ClientHttpRequestFactory)Validate.notNull((Object)requestFactory, (String)"requestFactory");
        this.baseUri = (URI)Validate.notNull((Object)baseUri, (String)"baseUri");
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        return this.requestFactory.createRequest(this.createUri(uri), httpMethod);
    }

    private URI createUri(URI uri) {
        URI result;
        Assert.notNull((Object)uri, (String)"URI must not be null");
        if (uri.isAbsolute() && uri.getHost() != null && !uri.getHost().equals(this.baseUri.getHost())) {
            return uri;
        }
        UriComponentsBuilder builder = UriComponentsBuilder.newInstance().scheme(this.baseUri.getScheme()).host(this.baseUri.getHost()).port(this.baseUri.getPort());
        String basePath = this.baseUri.getPath();
        String requestPath = uri.getPath();
        if (requestPath != null) {
            if (requestPath.startsWith("/")) {
                builder.path(requestPath);
            } else {
                String combinedPath = basePath != null && !basePath.endsWith("/") ? basePath + "/" + requestPath : requestPath;
                builder.path(combinedPath);
            }
        } else {
            builder.path(basePath);
        }
        if (uri.getQuery() != null) {
            builder.query(uri.getQuery());
        }
        if (uri.getFragment() != null) {
            builder.fragment(uri.getFragment());
        }
        if ((result = builder.build().toUri()).getHost() == null) {
            throw new IllegalStateException("Generated URI missing host information: " + String.valueOf(result) + " (baseUri: " + String.valueOf(this.baseUri) + ", requestUri: " + String.valueOf(uri) + ")");
        }
        return result;
    }

    public ClientHttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }
}

