/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import java.io.IOException;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.protocol.HttpContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestIdInterceptor
implements HttpRequestInterceptor {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        StringBuilder requestIdBuilder = new StringBuilder();
        Header requestIdHeader = request.getFirstHeader("X-GDC-REQUEST");
        if (requestIdHeader != null) {
            requestIdBuilder.append(requestIdHeader.getValue()).append(":");
        }
        String requestId = requestIdBuilder.append(RandomStringUtils.secure().nextAlphanumeric(16)).toString();
        request.setHeader("X-GDC-REQUEST", requestId);
    }
}

